/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.spring.autodeployment;

import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDeploymentBuilder;
import org.flowable.app.engine.AppEngine;
import org.flowable.app.spring.autodeployment.AbstractAppAutoDeploymentStrategy;
import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class DefaultAutoDeploymentStrategy
extends AbstractAppAutoDeploymentStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAutoDeploymentStrategy.class);
    public static final String DEPLOYMENT_MODE = "default";

    public DefaultAutoDeploymentStrategy() {
    }

    public DefaultAutoDeploymentStrategy(CommonAutoDeploymentProperties deploymentProperties) {
        super(deploymentProperties);
    }

    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    protected void deployResourcesInternal(String deploymentNameHint, Resource[] resources, AppEngine engine) {
        AppRepositoryService repositoryService = engine.getAppRepositoryService();
        for (Resource resource : resources) {
            String resourceName = this.determineResourceName(resource);
            if (resourceName.contains("/")) {
                resourceName = resourceName.substring(resourceName.lastIndexOf(47) + 1);
            } else if (resourceName.contains("\\")) {
                resourceName = resourceName.substring(resourceName.lastIndexOf(92) + 1);
            }
            AppDeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(resourceName);
            this.addResource(resource, resourceName, deploymentBuilder);
            try {
                deploymentBuilder.deploy();
            }
            catch (RuntimeException e) {
                if (this.isThrowExceptionOnDeploymentFailure()) {
                    throw e;
                }
                LOGGER.warn("Exception while autodeploying app definition for resource {}. This exception can be ignored if the root cause indicates a unique constraint violation, which is typically caused by two (or more) servers booting up at the exact same time and deploying the same definitions. ", (Object)resource, (Object)e);
            }
        }
    }
}

