/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.Map;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryManager;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.engine.impl.util.PlanItemInstanceUtil;
import org.flowable.cmmn.engine.impl.variable.CmmnAggregation;
import org.flowable.cmmn.model.RepetitionRule;
import org.flowable.cmmn.model.VariableAggregationDefinition;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class CreatePlanItemInstanceWithoutEvaluationOperation
extends AbstractPlanItemInstanceOperation {
    public CreatePlanItemInstanceWithoutEvaluationOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        super(commandContext, planItemInstanceEntity);
    }

    @Override
    public void run() {
        RepetitionRule repetitionRule = ExpressionUtil.getRepetitionRule(this.planItemInstanceEntity);
        if (repetitionRule != null) {
            int repetitionCounter = PlanItemInstanceUtil.getRepetitionCounter(this.planItemInstanceEntity);
            if (repetitionCounter == 0 && repetitionRule.getAggregations() != null) {
                Map<String, VariableAggregationDefinition> aggregationsByTarget = CmmnAggregation.groupAggregationsByTarget(this.planItemInstanceEntity, repetitionRule.getAggregations().getOverviewAggregations(), CommandContextUtil.getCmmnEngineConfiguration(this.commandContext));
                for (String variableName : aggregationsByTarget.keySet()) {
                    CmmnAggregation bpmnAggregation = new CmmnAggregation(this.planItemInstanceEntity.getId());
                    this.planItemInstanceEntity.getParentVariableScope().setVariable(variableName, (Object)bpmnAggregation);
                }
            }
            this.setRepetitionCounter(this.planItemInstanceEntity, repetitionCounter + 1);
        }
        CmmnHistoryManager cmmnHistoryManager = CommandContextUtil.getCmmnHistoryManager(this.commandContext);
        cmmnHistoryManager.recordPlanItemInstanceCreated(this.planItemInstanceEntity);
        this.planItemInstanceEntity.setLastAvailableTime(this.getCurrentTime(this.commandContext));
        cmmnHistoryManager.recordPlanItemInstanceAvailable(this.planItemInstanceEntity);
    }
}

