/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobService;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntity;

public class JobRetryCmd
implements Command<Object> {
    protected String jobId;
    protected Throwable exception;

    public JobRetryCmd(String jobId, Throwable exception) {
        this.jobId = jobId;
        this.exception = exception;
    }

    public Object execute(CommandContext commandContext) {
        JobService jobService = CommandContextUtil.getJobService(commandContext);
        TimerJobService timerJobService = CommandContextUtil.getTimerJobService(commandContext);
        JobEntity job = jobService.findJobById(this.jobId);
        if (job == null) {
            return null;
        }
        AbstractRuntimeJobEntity newJobEntity = null;
        newJobEntity = job.getRetries() <= 1 ? jobService.moveJobToDeadLetterJob((AbstractRuntimeJobEntity)job) : timerJobService.moveJobToTimerJob(job);
        newJobEntity.setRetries(job.getRetries() - 1);
        if (job.getDuedate() == null || "message".equals(job.getJobType())) {
            newJobEntity.setDuedate(this.calculateDueDate(commandContext, CommandContextUtil.getCmmnEngineConfiguration(commandContext).getAsyncFailedJobWaitTime(), null));
        } else {
            newJobEntity.setDuedate(this.calculateDueDate(commandContext, CommandContextUtil.getCmmnEngineConfiguration(commandContext).getDefaultFailedJobWaitTime(), job.getDuedate()));
        }
        if (this.exception != null) {
            newJobEntity.setExceptionMessage(this.exception.getMessage());
            newJobEntity.setExceptionStacktrace(this.getExceptionStacktrace());
        }
        return null;
    }

    protected Date calculateDueDate(CommandContext commandContext, int waitTimeInSeconds, Date oldDate) {
        GregorianCalendar newDateCal = new GregorianCalendar();
        if (oldDate != null) {
            newDateCal.setTime(oldDate);
        } else {
            newDateCal.setTime(CommandContextUtil.getCmmnEngineConfiguration(commandContext).getClock().getCurrentTime());
        }
        ((Calendar)newDateCal).add(13, waitTimeInSeconds);
        return newDateCal.getTime();
    }

    protected String getExceptionStacktrace() {
        StringWriter stringWriter = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

