/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.deployer;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;

public class ResourceNameUtil {
    public static final String[] DMN_RESOURCE_SUFFIXES = new String[]{"dmn.xml", "dmn"};
    public static final String[] DIAGRAM_SUFFIXES = new String[]{"png", "jpg", "gif", "svg"};

    public static String stripDmnFileSuffix(String dmnFileResource) {
        for (String suffix : DMN_RESOURCE_SUFFIXES) {
            if (!dmnFileResource.endsWith(suffix)) continue;
            return dmnFileResource.substring(0, dmnFileResource.length() - suffix.length());
        }
        return dmnFileResource;
    }

    public static String getDecisionRequirementsDiagramResourceName(String dmnFileResource, String decisionKey, String diagramSuffix) {
        String dmnFileResourceBase = ResourceNameUtil.stripDmnFileSuffix(dmnFileResource);
        return dmnFileResourceBase + decisionKey + "." + diagramSuffix;
    }

    public static String getDecisionRequirementsDiagramResourceNameFromDeployment(DecisionEntity decisionDefinition, Map<String, EngineResource> resources) {
        if (StringUtils.isEmpty((CharSequence)decisionDefinition.getResourceName())) {
            throw new IllegalStateException("Provided decision definition must have its resource name set.");
        }
        String dmnResourceBase = ResourceNameUtil.stripDmnFileSuffix(decisionDefinition.getResourceName());
        String key = decisionDefinition.getKey();
        for (String diagramSuffix : DIAGRAM_SUFFIXES) {
            String possibleName = dmnResourceBase + key + "." + diagramSuffix;
            if (resources.containsKey(possibleName)) {
                return possibleName;
            }
            possibleName = dmnResourceBase + diagramSuffix;
            if (!resources.containsKey(possibleName)) continue;
            return possibleName;
        }
        return null;
    }
}

