/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.logging;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.Session;
import org.flowable.common.engine.impl.logging.LoggingListener;
import org.flowable.common.engine.impl.logging.LoggingSessionCommandContextCloseListener;

public class LoggingSession
implements Session {
    protected CommandContext commandContext;
    protected LoggingSessionCommandContextCloseListener commandContextCloseListener;
    protected LoggingListener loggingListener;
    protected ObjectMapper objectMapper;
    protected List<ObjectNode> loggingData;

    public LoggingSession(CommandContext commandContext, LoggingListener loggingListener, ObjectMapper objectMapper) {
        this.commandContext = commandContext;
        this.loggingListener = loggingListener;
        this.objectMapper = objectMapper;
        this.initCommandContextCloseListener();
    }

    protected void initCommandContextCloseListener() {
        this.commandContextCloseListener = new LoggingSessionCommandContextCloseListener(this, this.loggingListener, this.objectMapper);
    }

    public void addLoggingData(String type, ObjectNode data, String engineType) {
        if (this.loggingData == null) {
            this.loggingData = new ArrayList<ObjectNode>();
            this.commandContextCloseListener.setEngineType(engineType);
            this.commandContext.addCloseListener(this.commandContextCloseListener);
        }
        String transactionId = null;
        transactionId = this.loggingData.size() > 0 ? this.loggingData.get(0).get("__transactionId").asText() : data.get("__id").asText();
        data.put("__transactionId", transactionId);
        data.put("__logNumber", this.loggingData.size() + 1);
        this.loggingData.add(data);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public List<ObjectNode> getLoggingData() {
        return this.loggingData;
    }

    public void setLoggingData(List<ObjectNode> loggingData) {
        this.loggingData = loggingData;
    }
}

