/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.jupiter.api.AssertionUtils;

class AssertNotEquals {
    private AssertNotEquals() {
    }

    static void assertNotEquals(byte unexpected, byte actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(byte unexpected, byte actual, @Nullable String message) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, message);
        }
    }

    static void assertNotEquals(byte unexpected, byte actual, Supplier<@Nullable String> messageSupplier) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, messageSupplier);
        }
    }

    static void assertNotEquals(short unexpected, short actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(short unexpected, short actual, @Nullable String message) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, message);
        }
    }

    static void assertNotEquals(short unexpected, short actual, Supplier<@Nullable String> messageSupplier) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, messageSupplier);
        }
    }

    static void assertNotEquals(int unexpected, int actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(int unexpected, int actual, @Nullable String message) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, message);
        }
    }

    static void assertNotEquals(int unexpected, int actual, Supplier<@Nullable String> messageSupplier) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, messageSupplier);
        }
    }

    static void assertNotEquals(long unexpected, long actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(long unexpected, long actual, @Nullable String message) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, message);
        }
    }

    static void assertNotEquals(long unexpected, long actual, Supplier<@Nullable String> messageSupplier) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, messageSupplier);
        }
    }

    static void assertNotEquals(float unexpected, float actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(float unexpected, float actual, @Nullable String message) {
        if (AssertionUtils.floatsAreEqual(unexpected, actual)) {
            AssertNotEquals.failEqual(Float.valueOf(actual), message);
        }
    }

    static void assertNotEquals(float unexpected, float actual, Supplier<@Nullable String> messageSupplier) {
        if (AssertionUtils.floatsAreEqual(unexpected, actual)) {
            AssertNotEquals.failEqual(Float.valueOf(actual), messageSupplier);
        }
    }

    static void assertNotEquals(float unexpected, float actual, float delta) {
        AssertNotEquals.assertNotEquals(unexpected, actual, delta, (String)null);
    }

    static void assertNotEquals(float unexpected, float actual, float delta, @Nullable String message) {
        if (AssertionUtils.floatsAreEqual(unexpected, actual, delta)) {
            AssertNotEquals.failEqual(Float.valueOf(actual), message);
        }
    }

    static void assertNotEquals(float unexpected, float actual, float delta, Supplier<@Nullable String> messageSupplier) {
        if (AssertionUtils.floatsAreEqual(unexpected, actual, delta)) {
            AssertNotEquals.failEqual(Float.valueOf(actual), messageSupplier);
        }
    }

    static void assertNotEquals(double unexpected, double actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(double unexpected, double actual, @Nullable String message) {
        if (AssertionUtils.doublesAreEqual(unexpected, actual)) {
            AssertNotEquals.failEqual(actual, message);
        }
    }

    static void assertNotEquals(double unexpected, double actual, Supplier<@Nullable String> messageSupplier) {
        if (AssertionUtils.doublesAreEqual(unexpected, actual)) {
            AssertNotEquals.failEqual(actual, messageSupplier);
        }
    }

    static void assertNotEquals(double unexpected, double actual, double delta) {
        AssertNotEquals.assertNotEquals(unexpected, actual, delta, (String)null);
    }

    static void assertNotEquals(double unexpected, double actual, double delta, @Nullable String message) {
        if (AssertionUtils.doublesAreEqual(unexpected, actual, delta)) {
            AssertNotEquals.failEqual(actual, message);
        }
    }

    static void assertNotEquals(double unexpected, double actual, double delta, Supplier<@Nullable String> messageSupplier) {
        if (AssertionUtils.doublesAreEqual(unexpected, actual, delta)) {
            AssertNotEquals.failEqual(actual, messageSupplier);
        }
    }

    static void assertNotEquals(char unexpected, char actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(char unexpected, char actual, @Nullable String message) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(Character.valueOf(actual), message);
        }
    }

    static void assertNotEquals(char unexpected, char actual, Supplier<@Nullable String> messageSupplier) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(Character.valueOf(actual), messageSupplier);
        }
    }

    static void assertNotEquals(@Nullable Object unexpected, @Nullable Object actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(@Nullable Object unexpected, @Nullable Object actual, @Nullable String message) {
        if (AssertionUtils.objectsAreEqual(unexpected, actual)) {
            AssertNotEquals.failEqual(actual, message);
        }
    }

    static void assertNotEquals(@Nullable Object unexpected, @Nullable Object actual, Supplier<@Nullable String> messageSupplier) {
        if (AssertionUtils.objectsAreEqual(unexpected, actual)) {
            AssertNotEquals.failEqual(actual, messageSupplier);
        }
    }

    private static void failEqual(@Nullable Object actual, @Nullable Object messageOrSupplier) {
        AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason("expected: not equal but was: <" + String.valueOf(actual) + ">").buildAndThrow();
    }
}

