/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.ap.internal.gem.BuilderGem;
import org.mapstruct.ap.internal.gem.DecoratedWithGem;
import org.mapstruct.ap.internal.gem.InheritConfigurationGem;
import org.mapstruct.ap.internal.gem.InheritInverseConfigurationGem;
import org.mapstruct.ap.internal.gem.MapperGem;
import org.mapstruct.ap.internal.gem.MappingInheritanceStrategyGem;
import org.mapstruct.ap.internal.gem.NullValueMappingStrategyGem;
import org.mapstruct.ap.internal.model.AbstractMappingMethodBuilder;
import org.mapstruct.ap.internal.model.BeanMappingMethod;
import org.mapstruct.ap.internal.model.ContainerMappingMethod;
import org.mapstruct.ap.internal.model.ContainerMappingMethodBuilder;
import org.mapstruct.ap.internal.model.Decorator;
import org.mapstruct.ap.internal.model.DefaultMapperReference;
import org.mapstruct.ap.internal.model.DelegatingMethod;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.IterableMappingMethod;
import org.mapstruct.ap.internal.model.MapMappingMethod;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.StreamMappingMethod;
import org.mapstruct.ap.internal.model.SupportingConstructorFragment;
import org.mapstruct.ap.internal.model.SupportingField;
import org.mapstruct.ap.internal.model.ValueMappingMethod;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.MapperOptions;
import org.mapstruct.ap.internal.model.source.MappingMethodOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;
import org.mapstruct.ap.internal.processor.creation.MappingResolverImpl;
import org.mapstruct.ap.internal.util.AccessorNamingUtils;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.ElementUtils;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.TypeUtils;
import org.mapstruct.ap.internal.version.VersionInformation;

public class MapperCreationProcessor
implements ModelElementProcessor<List<SourceMethod>, Mapper> {
    private static final List<Modifier> PUBLIC_CONSTANT_MODIFIERS = Arrays.asList(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
    private ElementUtils elementUtils;
    private TypeUtils typeUtils;
    private FormattingMessager messager;
    private Options options;
    private VersionInformation versionInformation;
    private TypeFactory typeFactory;
    private AccessorNamingUtils accessorNaming;
    private MappingBuilderContext mappingContext;

    @Override
    public Mapper process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, List<SourceMethod> sourceModel) {
        MappingBuilderContext ctx;
        this.elementUtils = context.getElementUtils();
        this.typeUtils = context.getTypeUtils();
        this.messager = context.getMessager();
        this.options = context.getOptions();
        this.versionInformation = context.getVersionInformation();
        this.typeFactory = context.getTypeFactory();
        this.accessorNaming = context.getAccessorNaming();
        MapperOptions mapperOptions = MapperOptions.getInstanceOn(mapperTypeElement, context.getOptions());
        List<MapperReference> mapperReferences = this.initReferencedMappers(mapperTypeElement, mapperOptions);
        this.mappingContext = ctx = new MappingBuilderContext(this.typeFactory, this.elementUtils, this.typeUtils, this.messager, this.accessorNaming, context.getEnumMappingStrategy(), context.getEnumTransformationStrategies(), this.options, new MappingResolverImpl(this.messager, this.elementUtils, this.typeUtils, this.typeFactory, new ArrayList<Method>(sourceModel), mapperReferences, this.options.isVerbose()), mapperTypeElement, java.util.Collections.unmodifiableList(sourceModel), mapperReferences);
        return this.getMapper(mapperTypeElement, mapperOptions, sourceModel);
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    private List<MapperReference> initReferencedMappers(TypeElement element, MapperOptions mapperAnnotation) {
        LinkedList<MapperReference> result = new LinkedList<MapperReference>();
        LinkedList<String> variableNames = new LinkedList<String>();
        for (TypeMirror typeMirror : mapperAnnotation.uses()) {
            DefaultMapperReference mapperReference = DefaultMapperReference.getInstance(this.typeFactory.getType(typeMirror), MapperGem.instanceOn(this.typeUtils.asElement(typeMirror)) != null, this.hasSingletonInstance(typeMirror), this.typeFactory, variableNames);
            result.add(mapperReference);
            variableNames.add(mapperReference.getVariableName());
        }
        return result;
    }

    private boolean hasSingletonInstance(TypeMirror mapper) {
        return this.typeUtils.asElement(mapper).getEnclosedElements().stream().anyMatch(a -> this.isPublicConstantOfType((Element)a, "INSTANCE", mapper));
    }

    private boolean isPublicConstantOfType(Element element, String fieldName, TypeMirror fieldType) {
        return element.getKind().isField() && element.getModifiers().containsAll(PUBLIC_CONSTANT_MODIFIERS) && element.getSimpleName().contentEquals(fieldName) && this.typeUtils.isSameType(element.asType(), fieldType);
    }

    private Mapper getMapper(TypeElement element, MapperOptions mapperOptions, List<SourceMethod> methods) {
        List<MappingMethod> mappingMethods = this.getMappingMethods(mapperOptions, methods);
        mappingMethods.addAll(this.mappingContext.getUsedSupportedMappings());
        mappingMethods.addAll(this.mappingContext.getMappingsToGenerate());
        ArrayList<Field> fields = new ArrayList<Field>(this.mappingContext.getMapperReferences());
        LinkedHashSet<Field> supportingFieldSet = new LinkedHashSet<Field>(this.mappingContext.getUsedSupportedFields());
        SupportingField.addAllFieldsIn(this.mappingContext.getUsedSupportedMappings(), supportingFieldSet);
        fields.addAll(supportingFieldSet);
        LinkedHashSet<SupportingConstructorFragment> constructorFragments = new LinkedHashSet<SupportingConstructorFragment>();
        SupportingConstructorFragment.addAllFragmentsIn(this.mappingContext.getUsedSupportedMappings(), constructorFragments);
        Mapper mapper = ((Mapper.Builder)((Mapper.Builder)((Mapper.Builder)((Mapper.Builder)((Mapper.Builder)((Mapper.Builder)new Mapper.Builder().element(element).methods((List)mappingMethods)).fields(fields).constructorFragments(constructorFragments).options(this.options)).versionInformation(this.versionInformation)).decorator(this.getDecorator(element, methods, mapperOptions.implementationName(), mapperOptions.implementationPackage(), this.getExtraImports(element, mapperOptions))).typeFactory(this.typeFactory)).elementUtils(this.elementUtils)).extraImports((SortedSet)this.getExtraImports(element, mapperOptions))).implName(mapperOptions.implementationName()).implPackage(mapperOptions.implementationPackage()).build();
        if (!this.mappingContext.getForgedMethodsUnderCreation().isEmpty()) {
            this.messager.printMessage((Element)element, Message.GENERAL_NOT_ALL_FORGED_CREATED, this.mappingContext.getForgedMethodsUnderCreation().keySet());
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.mappingContext.getMessager().printMessage((Element)element, Message.GENERAL_CANNOT_IMPLEMENT_PRIVATE_MAPPER, element.getSimpleName().toString(), element.getKind() == ElementKind.INTERFACE ? "interface" : "class");
        }
        return mapper;
    }

    private Decorator getDecorator(TypeElement element, List<SourceMethod> methods, String implName, String implPackage, SortedSet<Type> extraImports) {
        DecoratedWithGem decoratedWith = DecoratedWithGem.instanceOn(element);
        if (decoratedWith == null) {
            return null;
        }
        TypeElement decoratorElement = (TypeElement)this.typeUtils.asElement(decoratedWith.value().get());
        if (!this.typeUtils.isAssignable(decoratorElement.asType(), element.asType())) {
            this.messager.printMessage((Element)element, decoratedWith.mirror(), Message.DECORATOR_NO_SUBTYPE, new Object[0]);
        }
        ArrayList<DelegatingMethod> mappingMethods = new ArrayList<DelegatingMethod>(methods.size());
        for (SourceMethod mappingMethod : methods) {
            boolean implementationRequired = true;
            for (ExecutableElement method : ElementFilter.methodsIn(decoratorElement.getEnclosedElements())) {
                if (!this.elementUtils.overrides(method, mappingMethod.getExecutable(), decoratorElement)) continue;
                implementationRequired = false;
                break;
            }
            Type declaringMapper = mappingMethod.getDeclaringMapper();
            if (!implementationRequired || mappingMethod.isDefault() || mappingMethod.isStatic() || declaringMapper != null && !declaringMapper.equals(this.typeFactory.getType(element))) continue;
            mappingMethods.add(new DelegatingMethod(mappingMethod));
        }
        boolean hasDelegateConstructor = false;
        boolean hasDefaultConstructor = false;
        for (ExecutableElement constructor : ElementFilter.constructorsIn(decoratorElement.getEnclosedElements())) {
            if (constructor.getParameters().isEmpty()) {
                hasDefaultConstructor = true;
                continue;
            }
            if (constructor.getParameters().size() != 1 || !this.typeUtils.isAssignable(element.asType(), Collections.first(constructor.getParameters()).asType())) continue;
            hasDelegateConstructor = true;
        }
        if (!hasDelegateConstructor && !hasDefaultConstructor) {
            this.messager.printMessage((Element)element, decoratedWith.mirror(), Message.DECORATOR_CONSTRUCTOR, new Object[0]);
        }
        Decorator decorator = ((Decorator.Builder)((Decorator.Builder)((Decorator.Builder)((Decorator.Builder)((Decorator.Builder)((Decorator.Builder)new Decorator.Builder().elementUtils(this.elementUtils)).typeFactory(this.typeFactory)).mapperElement(element).decoratedWith(decoratedWith).methods(mappingMethods)).hasDelegateConstructor(hasDelegateConstructor).options(this.options)).versionInformation(this.versionInformation)).implName(implName).implPackage(implPackage).extraImports((SortedSet)extraImports)).build();
        return decorator;
    }

    private SortedSet<Type> getExtraImports(TypeElement element, MapperOptions mapperOptions) {
        TreeSet<Type> extraImports = new TreeSet<Type>();
        for (TypeMirror typeMirror : mapperOptions.imports()) {
            Type type = this.typeFactory.getType(typeMirror);
            extraImports.add(type);
        }
        if (!"default".equals(mapperOptions.implementationPackage())) {
            extraImports.add(this.typeFactory.getType(element));
        }
        return extraImports;
    }

    private List<MappingMethod> getMappingMethods(MapperOptions mapperAnnotation, List<SourceMethod> methods) {
        ArrayList<MappingMethod> mappingMethods = new ArrayList<MappingMethod>();
        for (SourceMethod method : methods) {
            Object builder;
            if (!method.overridesMethod()) continue;
            this.mergeInheritedOptions(method, mapperAnnotation, methods, new ArrayList<SourceMethod>());
            MappingMethodOptions mappingOptions = method.getOptions();
            boolean hasFactoryMethod = false;
            if (method.isIterableMapping()) {
                this.messager.note(1, Message.ITERABLEMAPPING_CREATE_NOTE, method);
                IterableMappingMethod iterableMappingMethod = this.createWithElementMappingMethod(method, mappingOptions, new IterableMappingMethod.Builder());
                hasFactoryMethod = iterableMappingMethod.getFactoryMethod() != null;
                mappingMethods.add(iterableMappingMethod);
            } else if (method.isMapMapping()) {
                builder = new MapMappingMethod.Builder();
                SelectionParameters keySelectionParameters = null;
                FormattingParameters keyFormattingParameters = null;
                SelectionParameters valueSelectionParameters = null;
                FormattingParameters valueFormattingParameters = null;
                NullValueMappingStrategyGem nullValueMappingStrategy = null;
                if (mappingOptions.getMapMapping() != null) {
                    keySelectionParameters = mappingOptions.getMapMapping().getKeySelectionParameters();
                    keyFormattingParameters = mappingOptions.getMapMapping().getKeyFormattingParameters();
                    valueSelectionParameters = mappingOptions.getMapMapping().getValueSelectionParameters();
                    valueFormattingParameters = mappingOptions.getMapMapping().getValueFormattingParameters();
                    nullValueMappingStrategy = mappingOptions.getMapMapping().getNullValueMappingStrategy();
                }
                this.messager.note(1, Message.MAPMAPPING_CREATE_NOTE, method);
                MapMappingMethod mapMappingMethod = ((MapMappingMethod.Builder)((MapMappingMethod.Builder)((AbstractMappingMethodBuilder)builder).mappingContext(this.mappingContext)).method(method)).keyFormattingParameters(keyFormattingParameters).keySelectionParameters(keySelectionParameters).valueFormattingParameters(valueFormattingParameters).valueSelectionParameters(valueSelectionParameters).build();
                hasFactoryMethod = mapMappingMethod.getFactoryMethod() != null;
                mappingMethods.add(mapMappingMethod);
            } else if (method.isValueMapping()) {
                this.messager.note(1, Message.VALUEMAPPING_CREATE_NOTE, method);
                ValueMappingMethod valueMappingMethod = new ValueMappingMethod.Builder().mappingContext(this.mappingContext).method(method).valueMappings(mappingOptions.getValueMappings()).enumMapping(mappingOptions.getEnumMappingOptions()).build();
                if (valueMappingMethod != null) {
                    mappingMethods.add(valueMappingMethod);
                }
            } else if (method.isRemovedEnumMapping()) {
                this.messager.printMessage((Element)method.getExecutable(), Message.ENUMMAPPING_REMOVED, new Object[0]);
            } else if (method.isStreamMapping()) {
                this.messager.note(1, Message.STREAMMAPPING_CREATE_NOTE, method);
                StreamMappingMethod streamMappingMethod = this.createWithElementMappingMethod(method, mappingOptions, new StreamMappingMethod.Builder());
                hasFactoryMethod = streamMappingMethod.getFactoryMethod() != null || method.getResultType().isStreamType();
                mappingMethods.add(streamMappingMethod);
            } else {
                this.messager.note(1, Message.BEANMAPPING_CREATE_NOTE, method);
                builder = method.getOptions().getBeanMapping().getBuilder();
                Type userDefinedReturnType = this.getUserDesiredReturnType(method);
                Type builderBaseType = userDefinedReturnType != null ? userDefinedReturnType : method.getReturnType();
                BeanMappingMethod.Builder beanMappingBuilder = new BeanMappingMethod.Builder();
                BeanMappingMethod beanMappingMethod = beanMappingBuilder.mappingContext(this.mappingContext).sourceMethod(method).userDefinedReturnType(userDefinedReturnType).returnTypeBuilder(this.typeFactory.builderTypeFor(builderBaseType, (BuilderGem)builder)).build();
                hasFactoryMethod = true;
                if (beanMappingMethod != null) {
                    mappingMethods.add(beanMappingMethod);
                }
            }
            if (hasFactoryMethod) continue;
            this.reportErrorIfNoImplementationTypeIsRegisteredForInterfaceReturnType(method);
        }
        return mappingMethods;
    }

    private Type getUserDesiredReturnType(SourceMethod method) {
        SelectionParameters selectionParameters = method.getOptions().getBeanMapping().getSelectionParameters();
        if (selectionParameters != null && selectionParameters.getResultType() != null) {
            return this.typeFactory.getType(selectionParameters.getResultType());
        }
        return null;
    }

    private <M extends ContainerMappingMethod> M createWithElementMappingMethod(SourceMethod method, MappingMethodOptions mappingMethodOptions, ContainerMappingMethodBuilder<?, M> builder) {
        FormattingParameters formattingParameters = null;
        SelectionParameters selectionParameters = null;
        if (mappingMethodOptions.getIterableMapping() != null) {
            formattingParameters = mappingMethodOptions.getIterableMapping().getFormattingParameters();
            selectionParameters = mappingMethodOptions.getIterableMapping().getSelectionParameters();
        }
        return (M)((ContainerMappingMethodBuilder)((ContainerMappingMethodBuilder)((ContainerMappingMethodBuilder)((ContainerMappingMethodBuilder)builder.mappingContext(this.mappingContext)).method(method)).formattingParameters(formattingParameters)).selectionParameters(selectionParameters)).build();
    }

    private void mergeInheritedOptions(SourceMethod method, MapperOptions mapperConfig, List<SourceMethod> availableMethods, List<SourceMethod> initializingMethods) {
        MappingInheritanceStrategyGem inheritanceStrategy;
        if (initializingMethods.contains(method)) {
            initializingMethods.add(method);
            this.messager.printMessage((Element)method.getExecutable(), Message.INHERITCONFIGURATION_CYCLE, Strings.join(initializingMethods, " -> "));
            return;
        }
        initializingMethods.add(method);
        MappingMethodOptions mappingOptions = method.getOptions();
        List<SourceMethod> applicableReversePrototypeMethods = method.getApplicableReversePrototypeMethods();
        SourceMethod inverseTemplateMethod = this.getInverseTemplateMethod(Collections.join(availableMethods, applicableReversePrototypeMethods), method, initializingMethods, mapperConfig);
        List<SourceMethod> applicablePrototypeMethods = method.getApplicablePrototypeMethods();
        SourceMethod forwardTemplateMethod = this.getForwardTemplateMethod(Collections.join(availableMethods, applicablePrototypeMethods), method, initializingMethods, mapperConfig);
        if (forwardTemplateMethod != null) {
            mappingOptions.applyInheritedOptions(forwardTemplateMethod, false);
        }
        if (inverseTemplateMethod != null) {
            mappingOptions.applyInheritedOptions(inverseTemplateMethod, true);
        }
        if ((inheritanceStrategy = mapperConfig.getMappingInheritanceStrategy()).isAutoInherit()) {
            if (forwardTemplateMethod == null && inheritanceStrategy.isApplyForward()) {
                if (applicablePrototypeMethods.size() == 1) {
                    mappingOptions.applyInheritedOptions(Collections.first(applicablePrototypeMethods), false);
                } else if (applicablePrototypeMethods.size() > 1) {
                    this.messager.printMessage((Element)method.getExecutable(), Message.INHERITCONFIGURATION_MULTIPLE_PROTOTYPE_METHODS_MATCH, Strings.join(applicablePrototypeMethods, ", "));
                }
            }
            if (inverseTemplateMethod == null && inheritanceStrategy.isApplyReverse()) {
                if (applicableReversePrototypeMethods.size() == 1) {
                    mappingOptions.applyInheritedOptions(Collections.first(applicableReversePrototypeMethods), true);
                } else if (applicableReversePrototypeMethods.size() > 1) {
                    this.messager.printMessage((Element)method.getExecutable(), Message.INHERITINVERSECONFIGURATION_MULTIPLE_PROTOTYPE_METHODS_MATCH, Strings.join(applicableReversePrototypeMethods, ", "));
                }
            }
        }
        if (mappingOptions.getBeanMapping() != null && mappingOptions.getBeanMapping().isignoreByDefault()) {
            mappingOptions.applyIgnoreAll(method, this.typeFactory, this.mappingContext.getMessager());
        }
        mappingOptions.markAsFullyInitialized();
    }

    private void reportErrorIfNoImplementationTypeIsRegisteredForInterfaceReturnType(Method method) {
        if (method.getReturnType().getTypeMirror().getKind() != TypeKind.VOID && method.getReturnType().isInterface() && method.getReturnType().getImplementationType() == null) {
            this.messager.printMessage((Element)method.getExecutable(), Message.GENERAL_NO_IMPLEMENTATION, method.getReturnType());
        }
    }

    private SourceMethod getInverseTemplateMethod(List<SourceMethod> rawMethods, SourceMethod method, List<SourceMethod> initializingMethods, MapperOptions mapperConfig) {
        SourceMethod resultMethod = null;
        InheritInverseConfigurationGem inverseConfiguration = InheritInverseConfigurationGem.instanceOn(method.getExecutable());
        if (inverseConfiguration != null) {
            ArrayList<SourceMethod> candidates = new ArrayList<SourceMethod>();
            for (SourceMethod oneMethod : rawMethods) {
                if (!method.inverses(oneMethod)) continue;
                candidates.add(oneMethod);
            }
            String name = inverseConfiguration.name().get();
            if (candidates.size() == 1) {
                if (name.isEmpty()) {
                    resultMethod = (SourceMethod)candidates.get(0);
                } else if (((SourceMethod)candidates.get(0)).getName().equals(name)) {
                    resultMethod = (SourceMethod)candidates.get(0);
                } else {
                    this.reportErrorWhenNonMatchingName((SourceMethod)candidates.get(0), method, inverseConfiguration);
                }
            } else if (candidates.size() > 1) {
                ArrayList<SourceMethod> nameFilteredcandidates = new ArrayList<SourceMethod>();
                for (SourceMethod candidate : candidates) {
                    if (!candidate.getName().equals(name)) continue;
                    nameFilteredcandidates.add(candidate);
                }
                if (nameFilteredcandidates.size() == 1) {
                    resultMethod = (SourceMethod)nameFilteredcandidates.get(0);
                } else if (nameFilteredcandidates.size() > 1) {
                    this.reportErrorWhenSeveralNamesMatch(nameFilteredcandidates, method, inverseConfiguration);
                } else {
                    this.reportErrorWhenAmbigousReverseMapping(candidates, method, inverseConfiguration);
                }
            }
        }
        return this.extractInitializedOptions(resultMethod, rawMethods, mapperConfig, initializingMethods);
    }

    private SourceMethod extractInitializedOptions(SourceMethod resultMethod, List<SourceMethod> rawMethods, MapperOptions mapperConfig, List<SourceMethod> initializingMethods) {
        if (resultMethod != null) {
            if (!resultMethod.getOptions().isFullyInitialized()) {
                this.mergeInheritedOptions(resultMethod, mapperConfig, rawMethods, initializingMethods);
            }
            return resultMethod;
        }
        return null;
    }

    private SourceMethod getForwardTemplateMethod(List<SourceMethod> rawMethods, SourceMethod method, List<SourceMethod> initializingMethods, MapperOptions mapperConfig) {
        SourceMethod resultMethod = null;
        InheritConfigurationGem inheritConfiguration = InheritConfigurationGem.instanceOn(method.getExecutable());
        if (inheritConfiguration != null) {
            ArrayList<SourceMethod> candidates = new ArrayList<SourceMethod>();
            for (SourceMethod oneMethod : rawMethods) {
                if (!method.canInheritFrom(oneMethod) || oneMethod.equals(method)) continue;
                candidates.add(oneMethod);
            }
            String name = inheritConfiguration.name().get();
            if (candidates.size() == 1) {
                SourceMethod sourceMethod = (SourceMethod)Collections.first(candidates);
                if (name.isEmpty()) {
                    resultMethod = sourceMethod;
                } else if (sourceMethod.getName().equals(name)) {
                    resultMethod = sourceMethod;
                } else {
                    this.reportErrorWhenNonMatchingName(sourceMethod, method, inheritConfiguration);
                }
            } else if (candidates.size() > 1) {
                ArrayList<SourceMethod> nameFilteredcandidates = new ArrayList<SourceMethod>();
                for (SourceMethod candidate : candidates) {
                    if (!candidate.getName().equals(name)) continue;
                    nameFilteredcandidates.add(candidate);
                }
                if (nameFilteredcandidates.size() == 1) {
                    resultMethod = (SourceMethod)Collections.first(nameFilteredcandidates);
                } else if (nameFilteredcandidates.size() > 1) {
                    this.reportErrorWhenSeveralNamesMatch(nameFilteredcandidates, method, inheritConfiguration);
                } else {
                    this.reportErrorWhenAmbigousMapping(candidates, method, inheritConfiguration);
                }
            }
        }
        return this.extractInitializedOptions(resultMethod, rawMethods, mapperConfig, initializingMethods);
    }

    private void reportErrorWhenAmbigousReverseMapping(List<SourceMethod> candidates, SourceMethod method, InheritInverseConfigurationGem inverseGem) {
        ArrayList<String> candidateNames = new ArrayList<String>();
        for (SourceMethod candidate : candidates) {
            candidateNames.add(candidate.getName());
        }
        String name = inverseGem.name().get();
        if (name.isEmpty()) {
            this.messager.printMessage((Element)method.getExecutable(), inverseGem.mirror(), Message.INHERITINVERSECONFIGURATION_DUPLICATES, Strings.join(candidateNames, "(), "));
        } else {
            this.messager.printMessage((Element)method.getExecutable(), inverseGem.mirror(), Message.INHERITINVERSECONFIGURATION_INVALID_NAME, Strings.join(candidateNames, "(), "), name);
        }
    }

    private void reportErrorWhenSeveralNamesMatch(List<SourceMethod> candidates, SourceMethod method, InheritInverseConfigurationGem inverseGem) {
        this.messager.printMessage((Element)method.getExecutable(), inverseGem.mirror(), Message.INHERITINVERSECONFIGURATION_DUPLICATE_MATCHES, inverseGem.name().get(), Strings.join(candidates, ", "));
    }

    private void reportErrorWhenNonMatchingName(SourceMethod onlyCandidate, SourceMethod method, InheritInverseConfigurationGem inverseGem) {
        this.messager.printMessage((Element)method.getExecutable(), inverseGem.mirror(), Message.INHERITINVERSECONFIGURATION_NO_NAME_MATCH, inverseGem.name().get(), onlyCandidate.getName());
    }

    private void reportErrorWhenAmbigousMapping(List<SourceMethod> candidates, SourceMethod method, InheritConfigurationGem gem) {
        ArrayList<String> candidateNames = new ArrayList<String>();
        for (SourceMethod candidate : candidates) {
            candidateNames.add(candidate.getName());
        }
        String name = gem.name().get();
        if (name.isEmpty()) {
            this.messager.printMessage((Element)method.getExecutable(), gem.mirror(), Message.INHERITCONFIGURATION_DUPLICATES, Strings.join(candidateNames, "(), "));
        } else {
            this.messager.printMessage((Element)method.getExecutable(), gem.mirror(), Message.INHERITCONFIGURATION_INVALIDNAME, Strings.join(candidateNames, "(), "), name);
        }
    }

    private void reportErrorWhenSeveralNamesMatch(List<SourceMethod> candidates, SourceMethod method, InheritConfigurationGem gem) {
        this.messager.printMessage((Element)method.getExecutable(), gem.mirror(), Message.INHERITCONFIGURATION_DUPLICATE_MATCHES, gem.name().get(), Strings.join(candidates, ", "));
    }

    private void reportErrorWhenNonMatchingName(SourceMethod onlyCandidate, SourceMethod method, InheritConfigurationGem gem) {
        this.messager.printMessage((Element)method.getExecutable(), gem.mirror(), Message.INHERITCONFIGURATION_NO_NAME_MATCH, gem.name().get(), onlyCandidate.getName());
    }
}

