/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request.grizzly;

import com.ning.http.client.providers.grizzly.HttpTransactionContext;
import java.io.IOException;
import java.util.EnumSet;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventLifeCycleListener;
import org.glassfish.grizzly.strategies.AbstractIOStrategy;
import org.mule.api.MuleException;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;

public class FlowWorkManagerIOStrategy
extends AbstractIOStrategy {
    private static final FlowWorkManagerIOStrategy INSTANCE = new FlowWorkManagerIOStrategy();
    private static final EnumSet<IOEvent> WORKER_THREAD_EVENT_SET = EnumSet.of(IOEvent.READ, IOEvent.CLOSED);
    private static final Logger logger = Grizzly.logger(FlowWorkManagerIOStrategy.class);

    protected FlowWorkManagerIOStrategy() {
    }

    public boolean executeIoEvent(Connection connection, IOEvent ioEvent, boolean isIoEventEnabled) throws IOException {
        IOEventLifeCycleListener listener;
        boolean isReadOrWriteEvent = FlowWorkManagerIOStrategy.isReadWrite((IOEvent)ioEvent);
        if (isReadOrWriteEvent) {
            if (isIoEventEnabled) {
                connection.disableIOEvent(ioEvent);
            }
            listener = ENABLE_INTEREST_LIFECYCLE_LISTENER;
        } else {
            listener = null;
        }
        Executor threadPool = this.getThreadPoolFor(connection, ioEvent);
        if (threadPool != null) {
            threadPool.execute(new WorkerThreadRunnable(connection, ioEvent, listener));
        } else {
            FlowWorkManagerIOStrategy.run0(connection, ioEvent, listener);
        }
        return true;
    }

    public Executor getThreadPoolFor(Connection connection, IOEvent ioEvent) {
        if (WORKER_THREAD_EVENT_SET.contains(ioEvent)) {
            try {
                WorkManager workManager = this.getWorkManager(connection);
                if (workManager != null) {
                    return workManager;
                }
            }
            catch (MuleException muleException) {
                // empty catch block
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Unable to obtain Mule WorkManager instance for worker thread IO. Grizzly WorkerIOStrategy will be used instead.");
            }
            return connection.getTransport().getWorkerThreadPool();
        }
        return null;
    }

    protected WorkManager getWorkManager(Connection connection) throws MuleException {
        HttpTransactionContext httpTransactionContext = (HttpTransactionContext)connection.getAttributes().getAttribute(HttpTransactionContext.class.getName());
        if (httpTransactionContext != null && httpTransactionContext.getAsyncHandler() instanceof WorkManagerSource) {
            return ((WorkManagerSource)httpTransactionContext.getAsyncHandler()).getWorkManager();
        }
        return null;
    }

    private static void run0(Connection connection, IOEvent ioEvent, IOEventLifeCycleListener lifeCycleListener) {
        FlowWorkManagerIOStrategy.fireIOEvent((Connection)connection, (IOEvent)ioEvent, (IOEventLifeCycleListener)lifeCycleListener, (Logger)logger);
    }

    public static FlowWorkManagerIOStrategy getInstance() {
        return INSTANCE;
    }

    private static final class WorkerThreadRunnable
    implements Runnable {
        final Connection connection;
        final IOEvent ioEvent;
        final IOEventLifeCycleListener lifeCycleListener;

        private WorkerThreadRunnable(Connection connection, IOEvent ioEvent, IOEventLifeCycleListener lifeCycleListener) {
            this.connection = connection;
            this.ioEvent = ioEvent;
            this.lifeCycleListener = lifeCycleListener;
        }

        @Override
        public void run() {
            FlowWorkManagerIOStrategy.run0(this.connection, this.ioEvent, this.lifeCycleListener);
        }
    }
}

