/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.misc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import sun.security.util.Debug;

public class SharedSecrets {
    private static final Debug debug = Debug.getInstance("compatible");
    private static final String[] candidateSharedSecretsClassNames = new String[]{"sun.misc.SharedSecrets", "jdk.internal.misc.SharedSecrets", "jdk.internal.access.SharedSecrets"};
    private static final String[] candidateJavaNetAccessClassNames = new String[]{"sun.misc.JavaNetAccess", "jdk.internal.misc.JavaNetInetAddressAccess", "jdk.internal.access.JavaNetInetAddressAccess"};
    private static Method getJavaNetAccessMethod;
    private static Method getOriginalHostNameMethod;

    private static void init() {
        SharedSecrets.initGetJavaNetAccessMethod();
        SharedSecrets.initGetOriginalHostNameMethod();
    }

    private static void initGetJavaNetAccessMethod() {
        block4: {
            Class<?> sharedSecretsClass = SharedSecrets.getSharedSecretsClass();
            if (sharedSecretsClass == null) {
                return;
            }
            String sharedSecretsClassName = sharedSecretsClass.getName().startsWith("sun.misc") ? "getJavaNetAccess" : "getJavaNetInetAddressAccess";
            try {
                getJavaNetAccessMethod = sharedSecretsClass.getDeclaredMethod(sharedSecretsClassName, new Class[0]);
                if (debug != null) {
                    debug.println("Found method " + getJavaNetAccessMethod.getName());
                }
            }
            catch (NoSuchMethodException e) {
                if (debug == null) break block4;
                debug.println("NoSuchMethodException: " + e.getMessage());
            }
        }
    }

    private static void initGetOriginalHostNameMethod() {
        block4: {
            Class<?> javaNetAccessClass = SharedSecrets.getJavaNetAccessClass();
            if (javaNetAccessClass == null) {
                return;
            }
            try {
                getOriginalHostNameMethod = javaNetAccessClass.getDeclaredMethod("getOriginalHostName", InetAddress.class);
                getOriginalHostNameMethod.setAccessible(true);
                if (debug != null) {
                    debug.println("Found method " + getOriginalHostNameMethod.getName());
                }
            }
            catch (NoSuchMethodException e) {
                if (debug == null) break block4;
                debug.println("NoSuchMethodException: " + e.getMessage());
            }
        }
    }

    private static Class<?> getSharedSecretsClass() {
        return SharedSecrets.getClass(candidateSharedSecretsClassNames);
    }

    private static Class<?> getJavaNetAccessClass() {
        return SharedSecrets.getClass(candidateJavaNetAccessClassNames);
    }

    private static Class<?> getClass(String[] classNames) {
        for (String className : classNames) {
            try {
                Class<?> clazz = Class.forName(className);
                if (debug != null) {
                    debug.println("Try load class " + className + " success");
                }
                return clazz;
            }
            catch (ClassNotFoundException e) {
                if (debug == null) continue;
                debug.println("Try load class " + className + " failed");
            }
        }
        if (debug != null) {
            debug.println("Can't find a suitable class from " + Arrays.toString(classNames));
        }
        return null;
    }

    private static Object getJavaNetAccess() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (getJavaNetAccessMethod == null) {
            throw new IllegalAccessException("getJavaNetAccess or JavaNetInetAddressAccess method not found");
        }
        return getJavaNetAccessMethod.invoke(null, new Object[0]);
    }

    public static String getOriginalHostName(InetAddress ia) {
        if (getOriginalHostNameMethod == null) {
            throw new IllegalStateException("getOriginalHostName method not found");
        }
        try {
            Object javaNetAccess = SharedSecrets.getJavaNetAccess();
            return (String)getOriginalHostNameMethod.invoke(javaNetAccess, ia);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SharedSecrets.init();
                return null;
            }
        });
    }
}

