/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.base.exception;

import cn.yzw.infra.component.base.exception.code.ErrorCode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractException
extends RuntimeException {
    private final int code;
    private final String message;
    private Map<String, Object> attributes;

    protected AbstractException(ErrorCode code) {
        super(code.getMessage());
        this.code = code.getCode();
        this.message = code.getMessage();
    }

    protected AbstractException(ErrorCode code, String message) {
        super(message);
        this.code = code.getCode();
        this.message = message;
    }

    protected AbstractException(ErrorCode code, String message, Throwable ex) {
        super(message, ex);
        this.code = code.getCode();
        this.message = message;
    }

    public AbstractException putAttribute(String key, Object value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
        return this;
    }

    public Map<String, Object> getAttributes() {
        return null == this.attributes ? Collections.emptyMap() : this.attributes;
    }

    public AbstractException setAttributes(Map<String, Object> attributes) {
        if (null != attributes) {
            this.attributes = attributes;
        }
        return this;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        return "AbstractException{code=" + this.code + ", message='" + this.message + '\'' + ", attributes=" + this.attributes + "} " + super.toString();
    }
}

