/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.base.exception;

import cn.yzw.infra.component.base.exception.AbstractException;
import cn.yzw.infra.component.base.exception.code.ErrorCode;
import cn.yzw.infra.component.base.exception.code.SystemErrorCode;

public class AuthException
extends AbstractException {
    protected AuthException(ErrorCode code) {
        super(code);
    }

    protected AuthException(ErrorCode code, String message) {
        super(code, message);
    }

    protected AuthException(ErrorCode code, String message, Throwable ex) {
        super(code, message, ex);
    }

    public static AuthException create(String message) {
        return AuthException.create(SystemErrorCode.REQUEST_UNAUTHORIZED, message);
    }

    public static AuthException create(final int code, final String message) {
        return AuthException.create(new ErrorCode(){

            @Override
            public int getCode() {
                return code;
            }

            @Override
            public String getMessage() {
                return message;
            }
        });
    }

    public static AuthException create(ErrorCode errorCode) {
        return new AuthException(errorCode);
    }

    public static AuthException create(ErrorCode errorCode, String message) {
        if (null == message) {
            return AuthException.create(errorCode);
        }
        return new AuthException(errorCode, message);
    }

    public static AuthException create(ErrorCode errorCode, String message, Throwable exception) {
        if (null == exception) {
            return AuthException.create(errorCode, message);
        }
        if (exception instanceof AuthException) {
            AuthException source = (AuthException)exception;
            if (null != errorCode && errorCode.getCode() != source.getCode()) {
                return new AuthException(errorCode, message, source);
            }
            return source;
        }
        return new AuthException(errorCode, message, exception);
    }
}

