/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.base.thread.pool;

import cn.yzw.infra.component.base.thread.factory.NamedThreadFactory;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoredThreadPool
extends ThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(MonitoredThreadPool.class);
    private ConcurrentHashMap<String, LocalDateTime> startTimes = new ConcurrentHashMap();
    private String threadPoolName;

    public MonitoredThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String threadPoolName) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, (ThreadFactory)new NamedThreadFactory(threadPoolName), threadPoolName);
    }

    public MonitoredThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, String poolName) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.threadPoolName = poolName;
    }

    @Override
    public void shutdown() {
        log.debug("\u7ebf\u7a0b\u6c60 {} \u51c6\u5907\u5173\u95ed\u3002\u5df2\u5904\u7406\u4efb\u52a1\u6570\uff1a{}\uff0c\u6b63\u5728\u8fd0\u884c\u4efb\u52a1\u6570\uff1a{}\uff0c\u7b49\u5f85\u4efb\u52a1\u6570\uff1a{}", new Object[]{this.threadPoolName, this.getCompletedTaskCount(), this.getActiveCount(), this.getQueue().size()});
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        log.debug("\u7ebf\u7a0b\u6c60 {} \u5f3a\u5236\u7acb\u5373\u5173\u95ed\u3002\u5df2\u5904\u7406\u4efb\u52a1\u6570\uff1a{}\uff0c\u6b63\u5728\u8fd0\u884c\u4efb\u52a1\u6570\uff1a{}\uff0c\u7b49\u5f85\u4efb\u52a1\u6570\uff1a{}", new Object[]{this.threadPoolName, this.getCompletedTaskCount(), this.getActiveCount(), this.getQueue().size()});
        return super.shutdownNow();
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.startTimes.put(String.valueOf(r.hashCode()), LocalDateTime.now());
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        LocalDateTime startTime = this.startTimes.remove(String.valueOf(r.hashCode()));
        LocalDateTime finishTime = LocalDateTime.now();
        Duration duration = Duration.between(startTime, finishTime);
        log.debug("\u7ebf\u7a0b\u6c60 {} \u76d1\u63a7\u4fe1\u606f\uff1a\u672c\u6b21\u4efb\u52a1\u8017\u65f6: {} ms, \u5f53\u524d\u7ebf\u7a0b\u6570: {}, \u6838\u5fc3\u7ebf\u7a0b\u6570: {}, \u6b63\u5728\u8fd0\u884c\u4efb\u52a1\u6570: {}, \u5df2\u5904\u7406\u4efb\u52a1\u6570: {}, \u4efb\u52a1\u603b\u6570: {}, \u7b49\u5f85\u4efb\u52a1\u6570: {}, \u6700\u5927\u6301\u6709\u8fc7\u7684\u7ebf\u7a0b\u6570: {}, \u6700\u5927\u7ebf\u7a0b\u6570: {},  \u7a7a\u95f2\u7ebf\u7a0b\u5b58\u6d3b\u65f6\u957f: {} ms, \u7ebf\u7a0b\u6c60\u5df2\u5173\u95ed: {}, \u7ebf\u7a0b\u6c60\u5df2\u505c\u6b62: {}", new Object[]{this.threadPoolName, duration.toMillis(), this.getPoolSize(), this.getCorePoolSize(), this.getActiveCount(), this.getCompletedTaskCount(), this.getTaskCount(), this.getQueue().size(), this.getLargestPoolSize(), this.getMaximumPoolSize(), this.getKeepAliveTime(TimeUnit.MILLISECONDS), this.isShutdown(), this.isTerminated()});
        super.afterExecute(r, t);
    }
}

