/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.fss.http;

import cn.yzw.infra.component.fss.intercept.CustomLogListener;
import cn.yzw.infra.component.fss.intercept.TenantRequestFilter;
import cn.yzw.infra.component.fss.model.HttpConfig;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FssOkHttp {
    private static final Logger log = LoggerFactory.getLogger(FssOkHttp.class);
    private OkHttpClient client;

    public static FssOkHttp build() {
        return Instance.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OkHttpClient init(boolean openTenant, HttpConfig httpConfig) {
        if (this.client == null) {
            FssOkHttp fssOkHttp = this;
            synchronized (fssOkHttp) {
                if (this.client == null) {
                    OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
                    if (openTenant) {
                        builder.addInterceptor((Interceptor)new TenantRequestFilter());
                    }
                    HttpConfig httpConfig2 = httpConfig = httpConfig == null ? new HttpConfig() : httpConfig;
                    if (httpConfig.isLogSwitch()) {
                        builder.eventListener((EventListener)new CustomLogListener());
                    }
                    builder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
                    builder.connectTimeout(Duration.ofMillis(httpConfig.getConnectTimeout()));
                    builder.readTimeout(Duration.ofMillis(httpConfig.getReadTimeout()));
                    builder.writeTimeout(Duration.ofMillis(httpConfig.getWriteTimeout()));
                    builder.retryOnConnectionFailure(httpConfig.isRetryOnConnectionFailure());
                    builder.connectionPool(new ConnectionPool(httpConfig.getMaxIdle(), httpConfig.getKeepAliveDuration(), TimeUnit.MINUTES));
                    this.client = builder.build();
                }
            }
        }
        return this.client;
    }

    private static class Instance {
        private static FssOkHttp instance = new FssOkHttp();

        private Instance() {
        }
    }
}

