/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.Configs;

public class SystemProperties {
    public static final byte serializer = SystemProperties.serializer();

    public static boolean tcp_nodelay() {
        return SystemProperties.getBool("bolt.tcp.nodelay", "true");
    }

    public static boolean tcp_so_reuseaddr() {
        return SystemProperties.getBool("bolt.tcp.so.reuseaddr", "true");
    }

    public static int tcp_so_backlog() {
        return SystemProperties.getInt("bolt.tcp.so.backlog", "1024");
    }

    public static boolean tcp_so_keepalive() {
        return SystemProperties.getBool("bolt.tcp.so.keepalive", "true");
    }

    public static int netty_io_ratio() {
        return SystemProperties.getInt("bolt.netty.io.ratio", "70");
    }

    public static boolean netty_buffer_pooled() {
        return SystemProperties.getBool("bolt.netty.buffer.pooled", "false");
    }

    public static int netty_buffer_low_watermark() {
        return SystemProperties.getInt("bolt.netty.buffer.low.watermark", Configs.NETTY_BUFFER_LOW_WATERMARK_DEFAULT);
    }

    public static int netty_buffer_high_watermark() {
        return SystemProperties.getInt("bolt.netty.buffer.high.watermark", Configs.NETTY_BUFFER_HIGH_WATERMARK_DEFAULT);
    }

    public static boolean tcp_idle_switch() {
        return SystemProperties.getBool("bolt.tcp.heartbeat.switch", "true");
    }

    public static int tcp_idle() {
        return SystemProperties.getInt("bolt.tcp.heartbeat.interval", "15000");
    }

    public static int tcp_idle_maxtimes() {
        return SystemProperties.getInt("bolt.tcp.heartbeat.maxtimes", "3");
    }

    public static int tcp_server_idle() {
        return SystemProperties.getInt("bolt.tcp.server.idle.interval", "90000");
    }

    public static int conn_create_tp_min_size() {
        return SystemProperties.getInt("bolt.conn.create.tp.min", "3");
    }

    public static int conn_create_tp_max_size() {
        return SystemProperties.getInt("bolt.conn.create.tp.max", "8");
    }

    public static int conn_create_tp_queue_size() {
        return SystemProperties.getInt("bolt.conn.create.tp.queue", "50");
    }

    public static int conn_create_tp_keepalive() {
        return SystemProperties.getInt("bolt.conn.create.tp.keepalive", "60");
    }

    public static int default_tp_min_size() {
        return SystemProperties.getInt("bolt.tp.min", "20");
    }

    public static int default_tp_max_size() {
        return SystemProperties.getInt("bolt.tp.max", "400");
    }

    public static int default_tp_queue_size() {
        return SystemProperties.getInt("bolt.tp.queue", "600");
    }

    public static int default_tp_keepalive_time() {
        return SystemProperties.getInt("bolt.tp.keepalive", "60");
    }

    public static boolean conn_reconnect_switch() {
        return SystemProperties.getBool("bolt.conn.reconnect.switch", "false");
    }

    public static boolean conn_monitor_switch() {
        return SystemProperties.getBool("bolt.conn.monitor.switch", "false");
    }

    public static long conn_monitor_initial_delay() {
        return SystemProperties.getLong("bolt.conn.monitor.initial.delay", "10000");
    }

    public static long conn_monitor_period() {
        return SystemProperties.getLong("bolt.conn.monitor.period", "180000");
    }

    public static int conn_threshold() {
        return SystemProperties.getInt("bolt.conn.threshold", "3");
    }

    public static int retry_detect_period() {
        return SystemProperties.getInt("bolt.retry.delete.period", "5000");
    }

    public static byte serializer() {
        return SystemProperties.getByte("bolt.serializer", Configs.SERIALIZER_DEFAULT);
    }

    protected static boolean getBool(String key, String defaultValue) {
        return Boolean.parseBoolean(System.getProperty(key, defaultValue));
    }

    protected static int getInt(String key, String defaultValue) {
        return Integer.parseInt(System.getProperty(key, defaultValue));
    }

    protected static byte getByte(String key, String defaultValue) {
        return Byte.parseByte(System.getProperty(key, defaultValue));
    }

    protected static long getLong(String key, String defaultValue) {
        return Long.parseLong(System.getProperty(key, defaultValue));
    }
}

