/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.remoting.handler;

import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.meta.registry.Registry;
import com.alipay.sofa.registry.server.meta.remoting.handler.AbstractServerHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class DataNodeHandler
extends AbstractServerHandler<DataNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeHandler.class);
    @Autowired
    private Registry metaServerRegistry;

    @Override
    public Object reply(Channel channel, DataNode dataNode) {
        NodeChangeResult nodeChangeResult;
        try {
            nodeChangeResult = this.metaServerRegistry.register(dataNode);
            LOGGER.info("Data node {} register success!result:{}", (Object)dataNode, (Object)nodeChangeResult);
        }
        catch (Exception e) {
            LOGGER.error("Data node register error!", (Throwable)e);
            throw new RuntimeException("Data node register error!", e);
        }
        return nodeChangeResult;
    }

    @Override
    public Class interest() {
        return DataNode.class;
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }
}

