/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.repository.annotation;

import com.alipay.sofa.registry.jraft.bootstrap.RaftClient;
import com.alipay.sofa.registry.jraft.processor.Processor;
import com.alipay.sofa.registry.jraft.processor.ProxyHandler;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.meta.remoting.RaftExchanger;
import com.alipay.sofa.registry.store.api.annotation.RaftReference;
import com.alipay.sofa.registry.store.api.annotation.RaftService;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

public class RaftAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftAnnotationBeanPostProcessor.class);
    @Autowired
    private RaftExchanger raftExchanger;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.processRaftReference(bean);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.processRaftService(bean, beanName);
        return bean;
    }

    private void processRaftReference(Object bean) {
        Class<?> beanClass = bean.getClass();
        ReflectionUtils.doWithFields(beanClass, field -> {
            RaftReference referenceAnnotation = field.getAnnotation(RaftReference.class);
            if (referenceAnnotation == null) {
                return;
            }
            Class<?> interfaceType = referenceAnnotation.interfaceType();
            if (interfaceType.equals(Void.TYPE)) {
                interfaceType = field.getType();
            }
            String serviceId = this.getServiceId(interfaceType, referenceAnnotation.uniqueId());
            Object proxy = this.getProxy(interfaceType, serviceId);
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)bean, (Object)proxy);
        }, field -> !Modifier.isStatic(field.getModifiers()) && field.isAnnotationPresent(RaftReference.class));
    }

    private Object getProxy(Class<?> interfaceType, String serviceId) {
        RaftClient client = this.raftExchanger.getRaftClient();
        if (client == null) {
            this.raftExchanger.startRaftClient();
            LOGGER.info("Raft client before started!");
        }
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{interfaceType}, (InvocationHandler)new ProxyHandler(interfaceType, serviceId, this.raftExchanger.getRaftClient()));
    }

    private void processRaftService(Object bean, String beanName) {
        Class beanClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        RaftService raftServiceAnnotation = beanClass.getAnnotation(RaftService.class);
        if (raftServiceAnnotation == null) {
            return;
        }
        Class<?> interfaceType = raftServiceAnnotation.interfaceType();
        if (interfaceType.equals(Void.TYPE)) {
            Class<?>[] interfaces = beanClass.getInterfaces();
            if (interfaces == null || interfaces.length == 0 || interfaces.length > 1) {
                throw new RuntimeException("Bean " + beanName + " does not has any interface or has more than one interface.");
            }
            interfaceType = interfaces[0];
        }
        String serviceUniqueId = this.getServiceId(interfaceType, raftServiceAnnotation.uniqueId());
        Processor.getInstance().addWorker(serviceUniqueId, (Class)interfaceType, bean);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private String getServiceId(Class<?> interfaceType, String uniqueId) {
        if (interfaceType == null) {
            throw new IllegalArgumentException("Get serviceId error!interfaceType can not be null!");
        }
        if (uniqueId != null && !uniqueId.isEmpty()) {
            return interfaceType.getName() + ":" + uniqueId;
        }
        return interfaceType.getName();
    }
}

