/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.repository.service;

import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.common.model.metaserver.DataOperator;
import com.alipay.sofa.registry.jraft.processor.AbstractSnapshotProcess;
import com.alipay.sofa.registry.jraft.processor.SnapshotProcess;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.meta.node.NodeOperator;
import com.alipay.sofa.registry.server.meta.repository.NodeConfirmStatusService;
import com.alipay.sofa.registry.store.api.annotation.RaftService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@RaftService(uniqueId="dataServer")
public class DataConfirmStatusService
extends AbstractSnapshotProcess
implements NodeConfirmStatusService<DataNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataConfirmStatusService.class);
    private ConcurrentHashMap<DataNode, Map<String, DataNode>> expectNodes = new ConcurrentHashMap();
    private BlockingQueue<NodeOperator> expectNodesOrders = new LinkedBlockingQueue<NodeOperator>();
    private Set<String> snapShotFileNames = new HashSet<String>();
    private static final String NODE_EXTEND_NAME = "expectNodes";
    private static final String NODE_ORDERS_EXTEND_NAME = "expectNodesOrders";

    public DataConfirmStatusService() {
    }

    public DataConfirmStatusService(ConcurrentHashMap<DataNode, Map<String, DataNode>> expectNodes, BlockingQueue<NodeOperator> expectNodesOrders) {
        this.expectNodes = expectNodes;
        this.expectNodesOrders = expectNodesOrders;
    }

    public SnapshotProcess copy() {
        return new DataConfirmStatusService(new ConcurrentHashMap<DataNode, Map<String, DataNode>>(this.expectNodes), new LinkedBlockingQueue<NodeOperator>(this.expectNodesOrders));
    }

    @Override
    public void putConfirmNode(DataNode node, DataOperator nodeOperate) {
        try {
            this.expectNodesOrders.put(new NodeOperator<DataNode>(node, nodeOperate));
            LOGGER.info("Put operate:{} node:{} expect be confirm.", (Object)nodeOperate, (Object)node);
        }
        catch (InterruptedException e) {
            LOGGER.error("Put expect status list interrupt!", (Throwable)e);
        }
    }

    @Override
    public NodeOperator<DataNode> peekConfirmNode() {
        return (NodeOperator)this.expectNodesOrders.peek();
    }

    @Override
    public NodeOperator<DataNode> pollConfirmNode() throws InterruptedException {
        return this.expectNodesOrders.poll(1L, TimeUnit.SECONDS);
    }

    @Override
    public Queue<NodeOperator> getAllConfirmNodes() {
        return this.expectNodesOrders;
    }

    @Override
    public Map<String, DataNode> putExpectNodes(DataNode confirmNode, Map<String, DataNode> addNodes) {
        this.expectNodes.put(confirmNode, addNodes);
        LOGGER.info("Put ExpectNodes: expect be confirm {} expectNodes all {}", (Object)confirmNode.getIp(), this.expectNodes);
        return addNodes;
    }

    @Override
    public Map<String, DataNode> getExpectNodes(DataNode confirmNode) {
        Map<String, DataNode> map = this.expectNodes.get(confirmNode);
        LOGGER.info("Get ExpectNodes:{} node:{} expect be confirm. expectNodes all {}", new Object[]{map, confirmNode.getIp(), this.expectNodes});
        return map;
    }

    @Override
    public Map<String, DataNode> removeExpectConfirmNodes(DataNode confirmNode, Collection<String> ips) {
        Map<String, DataNode> map = this.expectNodes.get(confirmNode);
        if (map != null) {
            if (ips != null && !ips.isEmpty()) {
                ips.forEach(ipAddress -> {
                    DataNode old = (DataNode)map.remove(ipAddress);
                    if (old == null) {
                        LOGGER.warn("Get Expect confirmNode ip {} not existed!", ipAddress);
                    }
                });
            }
        } else {
            LOGGER.warn("Get Expect confirmNode {} not existed!", (Object)confirmNode);
        }
        LOGGER.info("Remove expect confirmNode:{} remove ips:{}. return all {}", new Object[]{confirmNode.getIp(), ips, map});
        return map;
    }

    @Override
    public Map<String, DataNode> removeExpectNodes(DataNode confirmNode) {
        return this.expectNodes.remove(confirmNode);
    }

    public boolean save(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Input path can't be null!");
        }
        if (path.endsWith(NODE_ORDERS_EXTEND_NAME)) {
            return this.save(path, this.expectNodesOrders);
        }
        return this.save(path, this.expectNodes);
    }

    public synchronized boolean load(String path) {
        try {
            if (path == null) {
                throw new IllegalArgumentException("Input path can't be null!");
            }
            if (path.endsWith(NODE_ORDERS_EXTEND_NAME)) {
                BlockingQueue queue = (BlockingQueue)this.load(path, this.expectNodesOrders.getClass());
                this.expectNodesOrders.clear();
                this.expectNodesOrders.addAll(queue);
            } else {
                ConcurrentHashMap map = (ConcurrentHashMap)this.load(path, this.expectNodes.getClass());
                this.expectNodes.clear();
                this.expectNodes.putAll(map);
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Load confirm expect Nodes data error!", (Throwable)e);
            return false;
        }
    }

    public Set<String> getSnapshotFileNames() {
        if (!this.snapShotFileNames.isEmpty()) {
            return this.snapShotFileNames;
        }
        this.snapShotFileNames.add(this.getExtPath(this.getClass().getSimpleName(), NODE_EXTEND_NAME));
        this.snapShotFileNames.add(this.getExtPath(this.getClass().getSimpleName(), NODE_ORDERS_EXTEND_NAME));
        return this.snapShotFileNames;
    }

    private String getExtPath(String path, String extentName) {
        return path + "_" + extentName;
    }
}

