/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.client;

import com.aliyun.mns.client.AsyncCallback;
import com.aliyun.mns.client.AsyncResult;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.CloudTopic;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.client.Utils;
import com.aliyun.mns.client.impl.queue.CreateQueueAction;
import com.aliyun.mns.client.impl.queue.ListQueueAction;
import com.aliyun.mns.client.impl.topic.ListTopicAction;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.common.auth.ServiceCredentials;
import com.aliyun.mns.common.http.ClientConfiguration;
import com.aliyun.mns.common.http.DefaultServiceClient;
import com.aliyun.mns.common.http.ServiceClient;
import com.aliyun.mns.model.PagingListResult;
import com.aliyun.mns.model.QueueMeta;
import com.aliyun.mns.model.TopicMeta;
import com.aliyun.mns.model.request.queue.CreateQueueRequest;
import com.aliyun.mns.model.request.queue.ListQueueRequest;
import com.aliyun.mns.model.request.topic.ListTopicRequest;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultMNSClient
implements MNSClient {
    private static Log log = LogFactory.getLog(DefaultMNSClient.class);
    private URI endpoint;
    private ServiceClient serviceClient;
    private ServiceCredentials credentials = new ServiceCredentials();

    public DefaultMNSClient(String endpoint, String accessId, String accessKey) {
        this(endpoint, accessId, accessKey, null);
    }

    public DefaultMNSClient(String endpoint, String accessId, String accessKey, ClientConfiguration config) {
        this.setEndpoint(endpoint);
        this.credentials = new ServiceCredentials(accessId, accessKey);
        if (config == null) {
            config = new ClientConfiguration();
            config.setExceptContinue(false);
        }
        this.serviceClient = new DefaultServiceClient(config);
        if (log.isDebugEnabled()) {
            log.debug((Object)("initiated MNSClientImpl,accessId=" + accessId + ",accessKey=" + accessKey + ", endpoint=" + endpoint));
        }
    }

    protected DefaultMNSClient(ServiceCredentials credentials, ServiceClient serviceClient, String endpoint) {
        this.serviceClient = serviceClient;
        this.credentials = credentials;
        this.setEndpoint(endpoint);
    }

    @Override
    public void close() {
        if (this.serviceClient != null) {
            this.serviceClient.close();
        }
    }

    @Override
    public void open() {
        if (this.serviceClient != null) {
            this.serviceClient.open();
        }
    }

    @Override
    public boolean isOpen() {
        if (this.serviceClient != null) {
            return this.serviceClient.isOpen();
        }
        return false;
    }

    @Override
    public CloudQueue getQueueRef(String queueName) {
        return new CloudQueue(queueName, this.serviceClient, this.credentials, this.endpoint);
    }

    private void setEndpoint(String endpoint) throws IllegalArgumentException {
        this.endpoint = Utils.getHttpURI(endpoint);
    }

    public void addHeader(String key, String value) {
        this.serviceClient.addHeader(key, value);
    }

    public AsyncResult<String> createQueueAsync(QueueMeta queueMeta, AsyncCallback<String> callback) {
        CreateQueueAction action = new CreateQueueAction(this.serviceClient, this.credentials, this.endpoint);
        CreateQueueRequest request = new CreateQueueRequest();
        request.setRequestPath("queues/" + queueMeta.getQueueName());
        request.setQueueMeta(queueMeta);
        return action.execute(request, callback);
    }

    @Override
    public CloudQueue createQueue(QueueMeta queueMeta) throws ClientException, ServiceException {
        CloudQueue queue = new CloudQueue(queueMeta.getQueueName(), this.serviceClient, this.credentials, this.endpoint);
        queue.create(queueMeta);
        return queue;
    }

    @Override
    public PagingListResult<String> listQueueURL(String prefix, String marker, Integer retNumber) throws ClientException, ServiceException {
        PagingListResult<String> results = new PagingListResult<String>();
        PagingListResult<QueueMeta> list = this.listQueue(prefix, marker, retNumber, false);
        if (list != null && list.getResult() != null) {
            ArrayList<String> queues = new ArrayList<String>();
            for (QueueMeta meta : list.getResult()) {
                queues.add(meta.getQueueURL());
            }
            if (list.getMarker() != null) {
                results.setMarker(list.getMarker());
            }
            results.setResult(queues);
            return results;
        }
        return results;
    }

    @Override
    public PagingListResult<QueueMeta> listQueue(String prefix, String marker, Integer retNumber) throws ClientException, ServiceException {
        return this.listQueue(prefix, marker, retNumber, true);
    }

    private PagingListResult<QueueMeta> listQueue(String prefix, String marker, Integer retNumber, boolean withMeta) throws ClientException, ServiceException {
        ListQueueAction action = new ListQueueAction(this.serviceClient, this.credentials, this.endpoint);
        ListQueueRequest request = new ListQueueRequest();
        request.setRequestPath("/queues");
        request.setMarker(marker);
        request.setPrefix(prefix);
        request.setMaxRet(retNumber);
        request.setWithMeta(withMeta);
        return (PagingListResult)action.execute(request);
    }

    @Override
    public CloudTopic getTopicRef(String topicName) {
        return new CloudTopic(topicName, this.serviceClient, this.credentials, this.endpoint);
    }

    @Override
    public CloudTopic createTopic(TopicMeta meta) {
        CloudTopic topic = new CloudTopic(meta.getTopicName(), this.serviceClient, this.credentials, this.endpoint);
        topic.create(meta);
        return topic;
    }

    @Override
    public PagingListResult<TopicMeta> listTopic(String prefix, String marker, Integer retNumber) throws ClientException, ServiceException {
        return this.listTopic(prefix, marker, retNumber, true);
    }

    private PagingListResult<TopicMeta> listTopic(String prefix, String marker, Integer retNumber, boolean withMeta) throws ClientException, ServiceException {
        ListTopicAction action = new ListTopicAction(this.serviceClient, this.credentials, this.endpoint);
        ListTopicRequest request = new ListTopicRequest();
        request.setRequestPath("topics/".split("/")[0]);
        request.setMarker(marker);
        request.setPrefix(prefix);
        request.setMaxRet(retNumber);
        if (withMeta) {
            request.setWithMeta(withMeta);
        }
        return (PagingListResult)action.execute(request);
    }

    @Override
    public PagingListResult<String> listTopicURL(String prefix, String marker, Integer retNumber) throws ClientException, ServiceException {
        PagingListResult<TopicMeta> results = this.listTopic(prefix, marker, retNumber, false);
        PagingListResult<String> ret = new PagingListResult<String>();
        if (results != null) {
            ArrayList<String> topics = new ArrayList<String>();
            for (TopicMeta meta : results.getResult()) {
                topics.add(meta.getTopicURL());
            }
            ret.setResult(topics);
            ret.setMarker(results.getMarker());
        }
        return ret;
    }
}

