/*
 * Decompiled with CFR 0.152.
 */
package com.banboocloud.Codec;

import com.banboocloud.Codec.BamboocloudCipher;
import com.banboocloud.commons.codec.binary.Base64;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESCipher
implements BamboocloudCipher {
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    @Override
    public String encrypt(String content, String password) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            byte[] byteContent = content.getBytes("UTF-8");
            cipher.init(1, AESCipher.getSecretKey(password));
            byte[] result = cipher.doFinal(byteContent);
            return new String(Base64.encodeBase64(result), "UTF-8");
        }
        catch (Exception ex) {
            Logger.getLogger(AESCipher.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public String decrypt(String content, String password) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, AESCipher.getSecretKey(password));
            byte[] result = cipher.doFinal(Base64.decodeBase64(content.getBytes()));
            return new String(result, "UTF-8");
        }
        catch (Exception ex) {
            Logger.getLogger(AESCipher.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static SecretKeySpec getSecretKey(String password) {
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(KEY_ALGORITHM);
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(password.getBytes());
            kg.init(128, random);
            SecretKey secretKey = kg.generateKey();
            return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(AESCipher.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static void main(String[] args) {
        AESCipher cipherAES = new AESCipher();
        String s = "hello,\u60a8\u597d";
        System.out.println("s:" + s);
        String s1 = cipherAES.encrypt(s, "1234");
        System.out.println("s1:" + s1);
        System.out.println("s2:" + cipherAES.decrypt(s1, "1234"));
    }

    @Override
    public String AlgorithmName() {
        return KEY_ALGORITHM;
    }
}

