/*
 * Decompiled with CFR 0.152.
 */
package com.banboocloud.commons.codec.sm4;

import com.banboocloud.commons.codec.sm4.Sm4;
import com.banboocloud.commons.codec.sm4.Sm4Context;
import com.banboocloud.commons.codec.sm4.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Sm4Utils {
    private String secretKey = "";
    private String iv = "";
    private boolean hexString = false;
    private static Pattern P = Pattern.compile("\\s*|\t|\r|\n");
    private static final Logger logger = LoggerFactory.getLogger(Sm4Utils.class);

    public String encryptData_ECB(String plainText, String secretKey) {
        logger.debug("\u8fdb\u5165ECB\u52a0\u5bc6\u51fd\u6570\uff0c\u52a0\u5bc6\u5b57\u7b26\u4e32\u53c2\u6570plainText\uff1a" + plainText + ",\u52a0\u5bc6\u79d8\u94a5secretKey\uff1a" + secretKey);
        try {
            Sm4Context ctx = new Sm4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = this.hexString ? Util.hexStringToBytes(secretKey) : secretKey.getBytes();
            Sm4 sm4 = new Sm4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes("UTF-8"));
            String cipherText = new BASE64Encoder().encode(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Matcher m = P.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            logger.error("ECB\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public String decryptData_ECB(String cipherText, String secretKey) {
        logger.debug("\u8fdb\u5165ECB\u89e3\u5bc6\u51fd\u6570\uff0c\u89e3\u5bc6\u5b57\u7b26\u4e32\u53c2\u6570cipherText\uff1a" + cipherText + ",\u89e3\u5bc6\u79d8\u94a5secretKey\uff1a" + secretKey);
        try {
            Sm4Context ctx = new Sm4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = this.hexString ? Util.hexStringToBytes(secretKey) : secretKey.getBytes();
            Sm4 sm4 = new Sm4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, new BASE64Decoder().decodeBuffer(cipherText));
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            logger.error("ECB\u89e3\u5bc6\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public String encryptData_CBC(String plainText, String secretKey) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            Sm4Context ctx = new Sm4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (this.hexString) {
                keyBytes = Util.hexStringToBytes(secretKey);
                ivBytes = Util.hexStringToBytes(this.iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            Sm4 sm4 = new Sm4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, plainText.getBytes("UTF-8"));
            String cipherText = new BASE64Encoder().encode(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Matcher m = P.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptData_CBC(String cipherText, String secretKey) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            Sm4Context ctx = new Sm4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (this.hexString) {
                keyBytes = Util.hexStringToBytes(secretKey);
                ivBytes = Util.hexStringToBytes(this.iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            Sm4 sm4 = new Sm4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, new BASE64Decoder().decodeBuffer(cipherText));
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String decryptData(String encryptStr) {
        String decStr2;
        System.out.println("decryptData start.=>" + encryptStr);
        Sm4Utils sm4Utils = new Sm4Utils();
        try {
            decStr2 = sm4Utils.decryptData_ECB(encryptStr, "JLB6L6MJVIT5Z7IL");
            if (decStr2 != null) {
                System.out.println("decryptData decryptData_ECB successs." + decStr2);
                return decStr2;
            }
        }
        catch (Exception decStr2) {
            // empty catch block
        }
        try {
            decStr2 = sm4Utils.decryptData_CBC(encryptStr, "JLB6L6MJVIT5Z7IL");
            if (decStr2 != null) {
                System.out.println("decryptData decryptData_CBC successs." + decStr2);
            }
            return decStr2;
        }
        catch (Exception e) {
            return null;
        }
    }
}

