/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.access;

import com.github.ltsopensource.admin.access.domain.NodeOnOfflineLog;
import com.github.ltsopensource.admin.web.vo.NodeInfo;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.monitor.access.domain.JVMGCDataPo;
import com.github.ltsopensource.monitor.access.domain.JVMMemoryDataPo;
import com.github.ltsopensource.monitor.access.domain.JVMThreadDataPo;
import com.github.ltsopensource.monitor.access.domain.JobClientMDataPo;
import com.github.ltsopensource.monitor.access.domain.JobTrackerMDataPo;
import com.github.ltsopensource.monitor.access.domain.TaskTrackerMDataPo;
import com.github.ltsopensource.store.jdbc.dbutils.ResultSetHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RshHandler {
    public static final ResultSetHandler<List<Node>> NODE_LIST_RSH = new ResultSetHandler<List<Node>>(){

        public List<Node> handle(ResultSet rs) throws SQLException {
            ArrayList<Node> nodes = new ArrayList<Node>();
            while (rs.next()) {
                nodes.add(RshHandler.getNodeByRs(rs));
            }
            return nodes;
        }
    };
    public static final ResultSetHandler<Node> NODE_RSH = new ResultSetHandler<Node>(){

        public Node handle(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return RshHandler.getNodeByRs(rs);
            }
            return null;
        }
    };
    public static final ResultSetHandler<List<JobTrackerMDataPo>> JOB_TRACKER_SUM_M_DATA_RSH = new ResultSetHandler<List<JobTrackerMDataPo>>(){

        public List<JobTrackerMDataPo> handle(ResultSet rs) throws SQLException {
            ArrayList<JobTrackerMDataPo> list = new ArrayList<JobTrackerMDataPo>();
            while (rs.next()) {
                JobTrackerMDataPo po = new JobTrackerMDataPo();
                po.setTimestamp(Long.valueOf(rs.getLong("timestamp")));
                po.setReceiveJobNum(Long.valueOf(rs.getLong("receive_job_num")));
                po.setPushJobNum(Long.valueOf(rs.getLong("push_job_num")));
                po.setExeSuccessNum(Long.valueOf(rs.getLong("exe_success_num")));
                po.setExeFailedNum(Long.valueOf(rs.getLong("exe_failed_num")));
                po.setExeLaterNum(Long.valueOf(rs.getLong("exe_later_num")));
                po.setExeExceptionNum(Long.valueOf(rs.getLong("exe_exception_num")));
                po.setFixExecutingJobNum(Long.valueOf(rs.getLong("fix_executing_job_num")));
                list.add(po);
            }
            return list;
        }
    };
    public static final ResultSetHandler<List<NodeOnOfflineLog>> NODE_ON_OFFLINE_LOG_LIST_RSH = new ResultSetHandler<List<NodeOnOfflineLog>>(){

        public List<NodeOnOfflineLog> handle(ResultSet rs) throws SQLException {
            ArrayList<NodeOnOfflineLog> list = new ArrayList<NodeOnOfflineLog>();
            while (rs.next()) {
                NodeOnOfflineLog log = new NodeOnOfflineLog();
                log.setLogTime(rs.getTimestamp("log_time"));
                log.setEvent(rs.getString("event"));
                log.setNodeType(NodeType.convert((String)rs.getString("node_type")));
                log.setClusterName(rs.getString("cluster_name"));
                log.setIp(rs.getString("ip"));
                log.setPort(rs.getInt("port"));
                log.setHostName(rs.getString("host_name"));
                log.setGroup(rs.getString("group"));
                log.setCreateTime(rs.getLong("create_time"));
                log.setThreads(rs.getInt("threads"));
                log.setIdentity(rs.getString("identity"));
                log.setHttpCmdPort(rs.getInt("http_cmd_port"));
                list.add(log);
            }
            return list;
        }
    };
    public static final ResultSetHandler<List<TaskTrackerMDataPo>> TASK_TRACKER_SUM_M_DATA_RSH = new ResultSetHandler<List<TaskTrackerMDataPo>>(){

        public List<TaskTrackerMDataPo> handle(ResultSet rs) throws SQLException {
            ArrayList<TaskTrackerMDataPo> list = new ArrayList<TaskTrackerMDataPo>();
            while (rs.next()) {
                TaskTrackerMDataPo po = new TaskTrackerMDataPo();
                po.setTimestamp(Long.valueOf(rs.getLong("timestamp")));
                po.setExeSuccessNum(Long.valueOf(rs.getLong("exe_success_num")));
                po.setExeFailedNum(Long.valueOf(rs.getLong("exe_failed_num")));
                po.setExeLaterNum(Long.valueOf(rs.getLong("exe_later_num")));
                po.setExeExceptionNum(Long.valueOf(rs.getLong("exe_exception_num")));
                po.setTotalRunningTime(Long.valueOf(rs.getLong("total_running_time")));
                list.add(po);
            }
            return list;
        }
    };
    public static final ResultSetHandler<List<JobClientMDataPo>> JOB_CLIENT_SUM_M_DATA_RSH = new ResultSetHandler<List<JobClientMDataPo>>(){

        public List<JobClientMDataPo> handle(ResultSet rs) throws SQLException {
            ArrayList<JobClientMDataPo> list = new ArrayList<JobClientMDataPo>();
            while (rs.next()) {
                JobClientMDataPo po = new JobClientMDataPo();
                po.setTimestamp(Long.valueOf(rs.getLong("timestamp")));
                po.setSubmitSuccessNum(Long.valueOf(rs.getLong("submit_success_num")));
                po.setSubmitFailedNum(Long.valueOf(rs.getLong("submit_failed_num")));
                po.setFailStoreNum(Long.valueOf(rs.getLong("fail_store_num")));
                po.setSubmitFailStoreNum(Long.valueOf(rs.getLong("submit_fail_store_num")));
                po.setHandleFeedbackNum(Long.valueOf(rs.getLong("handle_feedback_num")));
                list.add(po);
            }
            return list;
        }
    };
    public static final ResultSetHandler<List<NodeInfo>> NODE_INFO_LIST_RSH = new ResultSetHandler<List<NodeInfo>>(){

        public List<NodeInfo> handle(ResultSet rs) throws SQLException {
            ArrayList<NodeInfo> list = new ArrayList<NodeInfo>();
            while (rs.next()) {
                NodeInfo nodeInfo = new NodeInfo();
                nodeInfo.setIdentity(rs.getString("identity"));
                nodeInfo.setNodeGroup(rs.getString("node_group"));
                list.add(nodeInfo);
            }
            return list;
        }
    };
    public static final ResultSetHandler<List<JVMMemoryDataPo>> JVM_MEMORY_SUM_M_DATA_RSH = new ResultSetHandler<List<JVMMemoryDataPo>>(){

        public List<JVMMemoryDataPo> handle(ResultSet rs) throws SQLException {
            ArrayList<JVMMemoryDataPo> list = new ArrayList<JVMMemoryDataPo>();
            while (rs.next()) {
                JVMMemoryDataPo po = new JVMMemoryDataPo();
                po.setTimestamp(Long.valueOf(rs.getLong("timestamp")));
                po.setHeapMemoryCommitted(Long.valueOf(rs.getLong("heap_memory_committed")));
                po.setHeapMemoryInit(Long.valueOf(rs.getLong("heap_memory_init")));
                po.setHeapMemoryMax(Long.valueOf(rs.getLong("heap_memory_max")));
                po.setHeapMemoryUsed(Long.valueOf(rs.getLong("heap_memory_used")));
                po.setNonHeapMemoryCommitted(Long.valueOf(rs.getLong("non_heap_memory_committed")));
                po.setNonHeapMemoryInit(Long.valueOf(rs.getLong("non_heap_memory_init")));
                po.setNonHeapMemoryMax(Long.valueOf(rs.getLong("non_heap_memory_max")));
                po.setNonHeapMemoryUsed(Long.valueOf(rs.getLong("non_heap_memory_used")));
                po.setPermGenCommitted(Long.valueOf(rs.getLong("perm_gen_committed")));
                po.setPermGenInit(Long.valueOf(rs.getLong("perm_gen_init")));
                po.setPermGenMax(Long.valueOf(rs.getLong("perm_gen_max")));
                po.setPermGenUsed(Long.valueOf(rs.getLong("perm_gen_used")));
                po.setOldGenCommitted(Long.valueOf(rs.getLong("old_gen_committed")));
                po.setOldGenInit(Long.valueOf(rs.getLong("old_gen_init")));
                po.setOldGenMax(Long.valueOf(rs.getLong("old_gen_max")));
                po.setOldGenUsed(Long.valueOf(rs.getLong("old_gen_used")));
                po.setEdenSpaceCommitted(Long.valueOf(rs.getLong("eden_space_committed")));
                po.setEdenSpaceInit(Long.valueOf(rs.getLong("eden_space_init")));
                po.setEdenSpaceMax(Long.valueOf(rs.getLong("eden_space_max")));
                po.setEdenSpaceUsed(Long.valueOf(rs.getLong("eden_space_used")));
                po.setSurvivorCommitted(Long.valueOf(rs.getLong("survivor_committed")));
                po.setSurvivorInit(Long.valueOf(rs.getLong("survivor_init")));
                po.setSurvivorMax(Long.valueOf(rs.getLong("survivor_max")));
                po.setSurvivorUsed(Long.valueOf(rs.getLong("survivor_used")));
                list.add(po);
            }
            return list;
        }
    };
    public static final ResultSetHandler<List<JVMGCDataPo>> JVM_GC_SUM_M_DATA_RSH = new ResultSetHandler<List<JVMGCDataPo>>(){

        public List<JVMGCDataPo> handle(ResultSet rs) throws SQLException {
            ArrayList<JVMGCDataPo> list = new ArrayList<JVMGCDataPo>();
            while (rs.next()) {
                JVMGCDataPo po = new JVMGCDataPo();
                po.setTimestamp(Long.valueOf(rs.getLong("timestamp")));
                po.setYoungGCCollectionCount(Long.valueOf(rs.getLong("young_gc_collection_count")));
                po.setYoungGCCollectionTime(Long.valueOf(rs.getLong("young_gc_collection_time")));
                po.setFullGCCollectionCount(Long.valueOf(rs.getLong("full_gc_collection_count")));
                po.setFullGCCollectionTime(Long.valueOf(rs.getLong("full_gc_collection_time")));
                po.setSpanYoungGCCollectionCount(Long.valueOf(rs.getLong("span_young_gc_collection_count")));
                po.setSpanYoungGCCollectionTime(Long.valueOf(rs.getLong("span_young_gc_collection_time")));
                po.setSpanFullGCCollectionCount(Long.valueOf(rs.getLong("span_full_gc_collection_count")));
                po.setSpanFullGCCollectionTime(Long.valueOf(rs.getLong("span_full_gc_collection_time")));
                list.add(po);
            }
            return list;
        }
    };
    public static final ResultSetHandler<List<JVMThreadDataPo>> JVM_THREAD_SUM_M_DATA_RSH = new ResultSetHandler<List<JVMThreadDataPo>>(){

        public List<JVMThreadDataPo> handle(ResultSet rs) throws SQLException {
            ArrayList<JVMThreadDataPo> list = new ArrayList<JVMThreadDataPo>();
            while (rs.next()) {
                JVMThreadDataPo po = new JVMThreadDataPo();
                po.setTimestamp(Long.valueOf(rs.getLong("timestamp")));
                po.setDaemonThreadCount(Integer.valueOf(rs.getInt("daemon_thread_count")));
                po.setThreadCount(Integer.valueOf(rs.getInt("thread_count")));
                po.setTotalStartedThreadCount(Long.valueOf(rs.getLong("total_started_thread_count")));
                po.setDeadLockedThreadCount(Integer.valueOf(rs.getInt("dead_locked_thread_count")));
                po.setProcessCpuTimeRate(Double.valueOf(rs.getDouble("process_cpu_time_rate")));
                list.add(po);
            }
            return list;
        }
    };

    private static Node getNodeByRs(ResultSet rs) throws SQLException {
        Node node = new Node();
        node.setIdentity(rs.getString("identity"));
        node.setClusterName(rs.getString("cluster_name"));
        node.setNodeType(NodeType.valueOf((String)rs.getString("node_type")));
        node.setIp(rs.getString("ip"));
        node.setPort(Integer.valueOf(rs.getInt("port")));
        node.setGroup(rs.getString("node_group"));
        node.setCreateTime(Long.valueOf(rs.getLong("create_time")));
        node.setThreads(Integer.valueOf(rs.getInt("threads")));
        node.setAvailable(rs.getInt("available") == 1);
        node.setHostName(rs.getString("host_name"));
        node.setHttpCmdPort(Integer.valueOf(rs.getInt("http_cmd_port")));
        return node;
    }
}

