/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.access.memory;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.exception.LtsRuntimeException;
import com.github.ltsopensource.store.jdbc.SqlTemplate;
import com.github.ltsopensource.store.jdbc.SqlTemplateFactory;
import com.github.ltsopensource.store.jdbc.exception.JdbcException;
import java.io.IOException;
import java.io.InputStream;

public abstract class MemoryAccess {
    private SqlTemplate sqlTemplate;

    public MemoryAccess() {
        Config config = new Config();
        config.setIdentity(StringUtils.generateUUID());
        config.setParameter("jdbc.datasource.provider", "h2");
        config.setParameter("jdbc.url", "jdbc:h2:mem:lts_admin;DB_CLOSE_DELAY=-1");
        config.setParameter("jdbc.username", "lts");
        config.setParameter("jdbc.password", "lts");
        this.sqlTemplate = SqlTemplateFactory.create((Config)config);
    }

    protected SqlTemplate getSqlTemplate() {
        return this.sqlTemplate;
    }

    protected String readSqlFile(String path) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        try {
            return FileUtils.read((InputStream)is, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new LtsRuntimeException("Read sql file : [" + path + "] error ", (Throwable)e);
        }
    }

    protected void createTable(String sql) throws JdbcException {
        try {
            this.getSqlTemplate().createTable(sql);
        }
        catch (Exception e) {
            throw new JdbcException("Create table error, sql=" + sql, (Throwable)e);
        }
    }
}

