/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.access.memory;

import com.github.ltsopensource.admin.access.RshHandler;
import com.github.ltsopensource.admin.access.memory.MemoryAccess;
import com.github.ltsopensource.admin.request.NodePaginationReq;
import com.github.ltsopensource.admin.response.PaginationRsp;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.CharacterUtils;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.store.jdbc.builder.DeleteSql;
import com.github.ltsopensource.store.jdbc.builder.InsertSql;
import com.github.ltsopensource.store.jdbc.builder.OrderByType;
import com.github.ltsopensource.store.jdbc.builder.SelectSql;
import com.github.ltsopensource.store.jdbc.builder.WhereSql;
import com.github.ltsopensource.store.jdbc.dbutils.JdbcTypeUtils;
import java.util.Date;
import java.util.List;

public class NodeMemCacheAccess
extends MemoryAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeMemCacheAccess.class);

    public NodeMemCacheAccess() {
        this.createTable(this.readSqlFile("sql/h2/lts_node.sql"));
    }

    private String getTableName() {
        return "lts_node";
    }

    public void addNode(List<Node> nodes) {
        for (Node node : nodes) {
            try {
                NodePaginationReq request = new NodePaginationReq();
                request.setIdentity(node.getIdentity());
                List<Node> existNodes = this.search(request);
                if (CollectionUtils.isNotEmpty(existNodes)) {
                    this.removeNode(existNodes);
                }
                new InsertSql(this.getSqlTemplate()).insert(this.getTableName()).columns(new String[]{"identity", "available", "cluster_name", "node_type", "ip", "port", "node_group", "create_time", "threads", "host_name", "http_cmd_port"}).values(new Object[]{node.getIdentity(), node.isAvailable() ? 1 : 0, node.getClusterName(), node.getNodeType().name(), node.getIp(), node.getPort(), node.getGroup(), node.getCreateTime(), node.getThreads(), node.getHostName(), node.getHttpCmdPort()}).doInsert();
            }
            catch (Exception e) {
                LOGGER.error("Insert {} error!", new Object[]{node, e});
            }
        }
    }

    public void clear() {
        new DeleteSql(this.getSqlTemplate()).delete().from().table(this.getTableName()).doDelete();
    }

    public void removeNode(List<Node> nodes) {
        for (Node node : nodes) {
            try {
                new DeleteSql(this.getSqlTemplate()).delete().from().table(this.getTableName()).where("identity = ?", (Object)node.getIdentity()).doDelete();
            }
            catch (Exception e) {
                LOGGER.error("Delete {} error!", new Object[]{node, e});
            }
        }
    }

    public Node getNodeByIdentity(String identity) {
        return (Node)new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).where("identity = ?", (Object)identity).single(RshHandler.NODE_RSH);
    }

    public List<Node> getNodeByNodeType(NodeType nodeType) {
        NodePaginationReq nodePaginationReq = new NodePaginationReq();
        nodePaginationReq.setNodeType(nodeType);
        nodePaginationReq.setLimit(Integer.MAX_VALUE);
        return this.search(nodePaginationReq);
    }

    public List<Node> search(NodePaginationReq request) {
        SelectSql selectSql = new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).whereSql(this.buildWhereSql(request));
        if (StringUtils.isNotEmpty((String[])new String[]{request.getField()})) {
            selectSql.orderBy().column(CharacterUtils.camelCase2Underscore((String)request.getField()), OrderByType.convert((String)request.getDirection()));
        }
        return selectSql.limit(request.getStart().intValue(), request.getLimit().intValue()).list(RshHandler.NODE_LIST_RSH);
    }

    private WhereSql buildWhereSql(NodePaginationReq request) {
        return new WhereSql().andOnNotEmpty("identity = ?", request.getIdentity()).andOnNotEmpty("node_group = ?", request.getNodeGroup()).andOnNotNull("node_type = ?", request.getNodeType() == null ? null : request.getNodeType().name()).andOnNotEmpty("ip = ?", request.getIp()).andOnNotNull("available = ?", (Object)request.getAvailable()).andBetween("create_time", (Object)JdbcTypeUtils.toTimestamp((Date)request.getStartDate()), (Object)JdbcTypeUtils.toTimestamp((Date)request.getEndDate()));
    }

    public PaginationRsp<Node> pageSelect(NodePaginationReq request) {
        PaginationRsp response = new PaginationRsp();
        Long results = (Long)new SelectSql(this.getSqlTemplate()).select().columns(new String[]{"count(1)"}).from().table(this.getTableName()).whereSql(this.buildWhereSql(request)).single();
        response.setResults(results.intValue());
        if (results > 0L) {
            List<Node> nodes = this.search(request);
            response.setRows(nodes);
        }
        return response;
    }
}

