/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.access.mysql;

import com.github.ltsopensource.admin.access.RshHandler;
import com.github.ltsopensource.admin.access.face.BackendJVMThreadAccess;
import com.github.ltsopensource.admin.request.JvmDataReq;
import com.github.ltsopensource.admin.request.MDataPaginationReq;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.monitor.access.domain.JVMThreadDataPo;
import com.github.ltsopensource.monitor.access.mysql.MysqlJVMThreadAccess;
import com.github.ltsopensource.store.jdbc.builder.DeleteSql;
import com.github.ltsopensource.store.jdbc.builder.SelectSql;
import com.github.ltsopensource.store.jdbc.builder.WhereSql;
import java.util.List;

public class MysqlBackendJVMThreadAccess
extends MysqlJVMThreadAccess
implements BackendJVMThreadAccess {
    public MysqlBackendJVMThreadAccess(Config config) {
        super(config);
    }

    @Override
    public void delete(JvmDataReq request) {
        new DeleteSql(this.getSqlTemplate()).delete().from().table(this.getTableName()).whereSql(this.buildWhereSql(request)).doDelete();
    }

    @Override
    public List<JVMThreadDataPo> queryAvg(MDataPaginationReq request) {
        return new SelectSql(this.getSqlTemplate()).select().columns(new String[]{"timestamp", "AVG(daemon_thread_count) AS daemon_thread_count", "AVG(thread_count) AS thread_count", "AVG(total_started_thread_count) AS total_started_thread_count", "AVG(dead_locked_thread_count) AS dead_locked_thread_count", "AVG(process_cpu_time_rate) AS process_cpu_time_rate"}).from().table(this.getTableName()).whereSql(this.buildWhereSql(request)).groupBy(new String[]{" timestamp ASC "}).limit(request.getStart().intValue(), request.getLimit().intValue()).list(RshHandler.JVM_THREAD_SUM_M_DATA_RSH);
    }

    public WhereSql buildWhereSql(JvmDataReq req) {
        return new WhereSql().andOnNotEmpty("identity = ?", req.getIdentity()).andBetween("timestamp", (Object)req.getStartTime(), (Object)req.getEndTime());
    }

    public WhereSql buildWhereSql(MDataPaginationReq request) {
        return new WhereSql().andOnNotNull("id = ?", (Object)request.getId()).andOnNotEmpty("identity = ?", request.getIdentity()).andOnNotEmpty("node_group = ?", request.getNodeGroup()).andBetween("timestamp", (Object)request.getStartTime(), (Object)request.getEndTime());
    }
}

