/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.access.mysql;

import com.github.ltsopensource.admin.access.RshHandler;
import com.github.ltsopensource.admin.access.face.BackendJobClientMAccess;
import com.github.ltsopensource.admin.request.MDataPaginationReq;
import com.github.ltsopensource.admin.web.vo.NodeInfo;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.monitor.access.domain.JobClientMDataPo;
import com.github.ltsopensource.monitor.access.mysql.MysqlJobClientMAccess;
import com.github.ltsopensource.store.jdbc.builder.DeleteSql;
import com.github.ltsopensource.store.jdbc.builder.SelectSql;
import com.github.ltsopensource.store.jdbc.builder.WhereSql;
import java.util.List;

public class MysqlBackendJobClientMAccess
extends MysqlJobClientMAccess
implements BackendJobClientMAccess {
    public MysqlBackendJobClientMAccess(Config config) {
        super(config);
    }

    @Override
    public void delete(MDataPaginationReq request) {
        new DeleteSql(this.getSqlTemplate()).delete().from().table(this.getTableName()).whereSql(this.buildWhereSql(request)).doDelete();
    }

    @Override
    public List<JobClientMDataPo> querySum(MDataPaginationReq request) {
        return new SelectSql(this.getSqlTemplate()).select().columns(new String[]{"timestamp", "SUM(submit_success_num) AS submit_success_num", "SUM(submit_failed_num) AS submit_failed_num", "SUM(fail_store_num) AS fail_store_num", "SUM(submit_fail_store_num) AS submit_fail_store_num", "SUM(handle_feedback_num) AS handle_feedback_num"}).from().table(this.getTableName()).whereSql(this.buildWhereSql(request)).groupBy(new String[]{" timestamp ASC "}).limit(request.getStart().intValue(), request.getLimit().intValue()).list(RshHandler.JOB_CLIENT_SUM_M_DATA_RSH);
    }

    @Override
    public List<NodeInfo> getJobClients() {
        return new SelectSql(this.getSqlTemplate()).select().columns(new String[]{"DISTINCT identity AS identity", "node_group"}).from().table(this.getTableName()).list(RshHandler.NODE_INFO_LIST_RSH);
    }

    public WhereSql buildWhereSql(MDataPaginationReq request) {
        return new WhereSql().andOnNotNull("id = ?", (Object)request.getId()).andOnNotEmpty("identity = ?", request.getIdentity()).andOnNotEmpty("node_group = ?", request.getNodeGroup()).andBetween("timestamp", (Object)request.getStartTime(), (Object)request.getEndTime());
    }
}

