/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.access.mysql;

import com.github.ltsopensource.admin.access.RshHandler;
import com.github.ltsopensource.admin.access.domain.NodeOnOfflineLog;
import com.github.ltsopensource.admin.access.face.BackendNodeOnOfflineLogAccess;
import com.github.ltsopensource.admin.request.NodeOnOfflineLogPaginationReq;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.monitor.access.mysql.MysqlAbstractJdbcAccess;
import com.github.ltsopensource.store.jdbc.builder.DeleteSql;
import com.github.ltsopensource.store.jdbc.builder.InsertSql;
import com.github.ltsopensource.store.jdbc.builder.OrderByType;
import com.github.ltsopensource.store.jdbc.builder.SelectSql;
import com.github.ltsopensource.store.jdbc.builder.WhereSql;
import java.util.List;

public class MysqlBackendNodeOnOfflineLogAccess
extends MysqlAbstractJdbcAccess
implements BackendNodeOnOfflineLogAccess {
    public MysqlBackendNodeOnOfflineLogAccess(Config config) {
        super(config);
    }

    protected String getTableName() {
        return "lts_admin_node_onoffline_log";
    }

    @Override
    public void insert(List<NodeOnOfflineLog> nodeOnOfflineLogs) {
        InsertSql insertSql = new InsertSql(this.getSqlTemplate()).insert(this.getTableName()).columns(new String[]{"log_time", "event", "node_type", "cluster_name", "ip", "port", "host_name", "group", "create_time", "threads", "identity", "http_cmd_port"});
        for (NodeOnOfflineLog nodeOnOfflineLog : nodeOnOfflineLogs) {
            insertSql.values(new Object[]{nodeOnOfflineLog.getLogTime(), nodeOnOfflineLog.getEvent(), nodeOnOfflineLog.getNodeType().name(), nodeOnOfflineLog.getClusterName(), nodeOnOfflineLog.getIp(), nodeOnOfflineLog.getPort(), nodeOnOfflineLog.getHostName(), nodeOnOfflineLog.getGroup(), nodeOnOfflineLog.getCreateTime(), nodeOnOfflineLog.getThreads(), nodeOnOfflineLog.getIdentity(), nodeOnOfflineLog.getHttpCmdPort()});
        }
        insertSql.doBatchInsert();
    }

    @Override
    public List<NodeOnOfflineLog> select(NodeOnOfflineLogPaginationReq request) {
        return new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).whereSql(this.buildWhereSql(request)).orderBy().column("log_time", OrderByType.DESC).limit(request.getStart().intValue(), request.getLimit().intValue()).list(RshHandler.NODE_ON_OFFLINE_LOG_LIST_RSH);
    }

    @Override
    public Long count(NodeOnOfflineLogPaginationReq request) {
        return (Long)new SelectSql(this.getSqlTemplate()).select().columns(new String[]{"count(1)"}).from().table(this.getTableName()).whereSql(this.buildWhereSql(request)).single();
    }

    @Override
    public void delete(NodeOnOfflineLogPaginationReq request) {
        new DeleteSql(this.getSqlTemplate()).delete().from().table(this.getTableName()).whereSql(this.buildWhereSql(request)).doDelete();
    }

    private WhereSql buildWhereSql(NodeOnOfflineLogPaginationReq request) {
        return new WhereSql().andOnNotEmpty("identity = ?", request.getIdentity()).andOnNotEmpty("group = ?", request.getGroup()).andOnNotEmpty("event = ?", request.getEvent()).andBetween("log_time", (Object)request.getStartLogTime(), (Object)request.getEndLogTime());
    }
}

