/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.access.mysql;

import com.github.ltsopensource.admin.access.RshHandler;
import com.github.ltsopensource.admin.access.face.BackendTaskTrackerMAccess;
import com.github.ltsopensource.admin.request.MDataPaginationReq;
import com.github.ltsopensource.admin.web.vo.NodeInfo;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.monitor.access.domain.TaskTrackerMDataPo;
import com.github.ltsopensource.monitor.access.mysql.MysqlTaskTrackerMAccess;
import com.github.ltsopensource.store.jdbc.builder.DeleteSql;
import com.github.ltsopensource.store.jdbc.builder.SelectSql;
import com.github.ltsopensource.store.jdbc.builder.WhereSql;
import java.util.List;

public class MysqlBackendTaskTrackerMAccess
extends MysqlTaskTrackerMAccess
implements BackendTaskTrackerMAccess {
    public MysqlBackendTaskTrackerMAccess(Config config) {
        super(config);
    }

    @Override
    public List<TaskTrackerMDataPo> querySum(MDataPaginationReq request) {
        return new SelectSql(this.getSqlTemplate()).select().columns(new String[]{"timestamp", "SUM(exe_success_num) AS exe_success_num", "SUM(exe_failed_num) AS exe_failed_num", "SUM(exe_later_num) AS exe_later_num", "SUM(exe_exception_num) AS exe_exception_num", "SUM(total_running_time) AS total_running_time"}).from().table(this.getTableName()).whereSql(this.buildWhereSql(request)).groupBy(new String[]{" timestamp ASC "}).limit(request.getStart().intValue(), request.getLimit().intValue()).list(RshHandler.TASK_TRACKER_SUM_M_DATA_RSH);
    }

    @Override
    public void delete(MDataPaginationReq request) {
        new DeleteSql(this.getSqlTemplate()).delete().from().table(this.getTableName()).whereSql(this.buildWhereSql(request)).doDelete();
    }

    @Override
    public List<NodeInfo> getTaskTrackers() {
        return new SelectSql(this.getSqlTemplate()).select().columns(new String[]{"DISTINCT identity", "node_group"}).from().table(this.getTableName()).list(RshHandler.NODE_INFO_LIST_RSH);
    }

    public WhereSql buildWhereSql(MDataPaginationReq request) {
        return new WhereSql().andOnNotNull("id = ?", (Object)request.getId()).andOnNotEmpty("identity = ?", request.getIdentity()).andOnNotEmpty("node_group = ?", request.getNodeGroup()).andBetween("timestamp", (Object)request.getStartTime(), (Object)request.getEndTime());
    }
}

