/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.cluster;

import com.github.ltsopensource.admin.access.domain.NodeOnOfflineLog;
import com.github.ltsopensource.admin.cluster.BackendAppContext;
import com.github.ltsopensource.admin.request.NodePaginationReq;
import com.github.ltsopensource.admin.response.PaginationRsp;
import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.registry.AbstractRegistry;
import com.github.ltsopensource.core.registry.NotifyEvent;
import com.github.ltsopensource.core.registry.NotifyListener;
import com.github.ltsopensource.core.registry.Registry;
import com.github.ltsopensource.core.registry.RegistryFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BackendRegistrySrv {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackendRegistrySrv.class);
    private BackendAppContext appContext;
    private Registry registry;
    private NotifyListener notifyListener;

    public BackendRegistrySrv(BackendAppContext appContext) {
        this.appContext = appContext;
    }

    private void subscribe() {
        if (this.registry instanceof AbstractRegistry) {
            ((AbstractRegistry)this.registry).setNode(this.appContext.getNode());
        }
        this.registry.subscribe(this.appContext.getNode(), this.notifyListener);
    }

    public void reSubscribe() {
        this.registry.unsubscribe(this.appContext.getNode(), this.notifyListener);
        this.appContext.getNodeMemCacheAccess().clear();
        this.subscribe();
    }

    public PaginationRsp<Node> getOnlineNodes(NodePaginationReq request) {
        return this.appContext.getNodeMemCacheAccess().pageSelect(request);
    }

    private void addLog(NotifyEvent event, List<Node> nodes) {
        ArrayList<NodeOnOfflineLog> logs = new ArrayList<NodeOnOfflineLog>(nodes.size());
        for (Node node : nodes) {
            NodeOnOfflineLog log = new NodeOnOfflineLog();
            log.setLogTime(new Date());
            log.setEvent(event == NotifyEvent.ADD ? "ONLINE" : "OFFLINE");
            log.setClusterName(node.getClusterName());
            log.setCreateTime(node.getCreateTime());
            log.setGroup(node.getGroup());
            log.setHostName(node.getHostName());
            log.setIdentity(node.getIdentity());
            log.setIp(node.getIp());
            log.setPort(node.getPort());
            log.setThreads(node.getThreads());
            log.setNodeType(node.getNodeType());
            log.setHttpCmdPort(node.getHttpCmdPort());
            logs.add(log);
        }
        this.appContext.getBackendNodeOnOfflineLogAccess().insert(logs);
    }

    public void start() throws Exception {
        this.registry = RegistryFactory.getRegistry((AppContext)this.appContext);
        this.notifyListener = new NotifyListener(){

            public void notify(NotifyEvent event, List<Node> nodes) {
                if (CollectionUtils.isEmpty(nodes)) {
                    return;
                }
                switch (event) {
                    case ADD: {
                        BackendRegistrySrv.this.appContext.getNodeMemCacheAccess().addNode(nodes);
                        LOGGER.info("ADD NODE " + nodes);
                        break;
                    }
                    case REMOVE: {
                        BackendRegistrySrv.this.appContext.getNodeMemCacheAccess().removeNode(nodes);
                        LOGGER.info("REMOVE NODE " + nodes);
                    }
                }
                BackendRegistrySrv.this.addLog(event, nodes);
            }
        };
        this.subscribe();
    }
}

