/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.support;

import com.github.ltsopensource.admin.access.BackendAccessFactory;
import com.github.ltsopensource.admin.access.memory.NodeMemCacheAccess;
import com.github.ltsopensource.admin.cluster.BackendAppContext;
import com.github.ltsopensource.admin.cluster.BackendNode;
import com.github.ltsopensource.admin.cluster.BackendRegistrySrv;
import com.github.ltsopensource.admin.support.AppConfigurer;
import com.github.ltsopensource.admin.web.support.NoRelyJobGenerator;
import com.github.ltsopensource.biz.logger.JobLogger;
import com.github.ltsopensource.biz.logger.SmartJobLogger;
import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.utils.BeanUtils;
import com.github.ltsopensource.core.commons.utils.NetUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.registry.RegistryStatMonitor;
import com.github.ltsopensource.core.spi.ServiceLoader;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.ec.EventCenter;
import com.github.ltsopensource.queue.JobQueueFactory;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class BackendAppContextFactoryBean
implements FactoryBean<BackendAppContext>,
InitializingBean {
    private BackendAppContext appContext;

    public BackendAppContext getObject() throws Exception {
        return this.appContext;
    }

    public Class<?> getObjectType() {
        return BackendAppContext.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        BackendNode node = new BackendNode();
        node.setCreateTime(SystemClock.now());
        node.setIp(NetUtils.getLocalHost());
        node.setHostName(NetUtils.getLocalHostName());
        node.setIdentity("LTS_admin_" + StringUtils.generateUUID());
        Config config = new Config();
        config.setIdentity(node.getIdentity());
        config.setNodeType(node.getNodeType());
        config.setRegistryAddress(AppConfigurer.getProperty("registryAddress"));
        String clusterName = AppConfigurer.getProperty("clusterName");
        if (StringUtils.isEmpty((String)clusterName)) {
            throw new IllegalArgumentException("clusterName in lts-admin.cfg can not be null.");
        }
        config.setClusterName(clusterName);
        for (Map.Entry<String, String> entry : AppConfigurer.allConfig().entrySet()) {
            if (!entry.getKey().startsWith("configs.")) continue;
            config.setParameter(entry.getKey().replaceFirst("configs.", ""), entry.getValue());
        }
        this.appContext = new BackendAppContext();
        this.appContext.setConfig(config);
        this.appContext.setNode(node);
        this.appContext.setEventCenter((EventCenter)ServiceLoader.load(EventCenter.class, (Config)config));
        this.appContext.setRegistryStatMonitor(new RegistryStatMonitor((AppContext)this.appContext));
        this.appContext.setBackendRegistrySrv(new BackendRegistrySrv(this.appContext));
        this.initAccess(config);
        Config jobTConfig = (Config)BeanUtils.deepClone((Object)config);
        for (Map.Entry<String, String> entry : AppConfigurer.allConfig().entrySet()) {
            if (!entry.getKey().startsWith("jobT.")) continue;
            String key = entry.getKey().replace("jobT.", "");
            String value = entry.getValue();
            jobTConfig.setParameter(key, value);
        }
        this.initJobQueue(jobTConfig);
        this.appContext.getBackendRegistrySrv().start();
    }

    private void initJobQueue(Config config) {
        JobQueueFactory factory = (JobQueueFactory)ServiceLoader.load(JobQueueFactory.class, (Config)config);
        this.appContext.setExecutableJobQueue(factory.getExecutableJobQueue(config));
        this.appContext.setExecutingJobQueue(factory.getExecutingJobQueue(config));
        this.appContext.setCronJobQueue(factory.getCronJobQueue(config));
        this.appContext.setRepeatJobQueue(factory.getRepeatJobQueue(config));
        this.appContext.setSuspendJobQueue(factory.getSuspendJobQueue(config));
        this.appContext.setJobFeedbackQueue(factory.getJobFeedbackQueue(config));
        this.appContext.setNodeGroupStore(factory.getNodeGroupStore(config));
        this.appContext.setJobLogger((JobLogger)new SmartJobLogger((AppContext)this.appContext));
        this.appContext.setNoRelyJobGenerator(new NoRelyJobGenerator(this.appContext));
    }

    private void initAccess(Config config) {
        BackendAccessFactory factory = (BackendAccessFactory)ServiceLoader.load(BackendAccessFactory.class, (Config)config);
        this.appContext.setBackendJobClientMAccess(factory.getBackendJobClientMAccess(config));
        this.appContext.setBackendJobTrackerMAccess(factory.getJobTrackerMAccess(config));
        this.appContext.setBackendTaskTrackerMAccess(factory.getBackendTaskTrackerMAccess(config));
        this.appContext.setBackendJVMGCAccess(factory.getBackendJVMGCAccess(config));
        this.appContext.setBackendJVMMemoryAccess(factory.getBackendJVMMemoryAccess(config));
        this.appContext.setBackendJVMThreadAccess(factory.getBackendJVMThreadAccess(config));
        this.appContext.setBackendNodeOnOfflineLogAccess(factory.getBackendNodeOnOfflineLogAccess(config));
        this.appContext.setNodeMemCacheAccess(new NodeMemCacheAccess());
    }
}

