/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.support;

import com.github.ltsopensource.admin.cluster.BackendAppContext;
import com.github.ltsopensource.admin.request.JvmDataReq;
import com.github.ltsopensource.admin.request.MDataPaginationReq;
import com.github.ltsopensource.admin.request.NodeOnOfflineLogPaginationReq;
import com.github.ltsopensource.core.commons.utils.Callable;
import com.github.ltsopensource.core.commons.utils.DateUtils;
import com.github.ltsopensource.core.commons.utils.QuietUtils;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class LtsAdminDataCleaner
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(LtsAdminDataCleaner.class);
    @Autowired
    private BackendAppContext appContext;
    private ScheduledExecutorService cleanExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("LTS-Admin-Clean", true));
    private AtomicBoolean start = new AtomicBoolean(false);

    public void start() {
        if (this.start.compareAndSet(false, true)) {
            this.cleanExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        LtsAdminDataCleaner.this.clean();
                    }
                    catch (Throwable t) {
                        LOGGER.error("Clean monitor data error ", t);
                    }
                }
            }, 1L, 24L, TimeUnit.HOURS);
            LOGGER.info("LtsAdminDataCleaner start succeed ");
        }
    }

    private void clean() {
        final MDataPaginationReq request = new MDataPaginationReq();
        request.setEndTime(DateUtils.addDay((Date)new Date(), (int)-3).getTime());
        QuietUtils.doWithWarn((Callable)new Callable(){

            public void call() throws Exception {
                LtsAdminDataCleaner.this.appContext.getBackendTaskTrackerMAccess().delete(request);
            }
        });
        QuietUtils.doWithWarn((Callable)new Callable(){

            public void call() throws Exception {
                LtsAdminDataCleaner.this.appContext.getBackendJobTrackerMAccess().delete(request);
            }
        });
        QuietUtils.doWithWarn((Callable)new Callable(){

            public void call() throws Exception {
                LtsAdminDataCleaner.this.appContext.getBackendJobClientMAccess().delete(request);
            }
        });
        final NodeOnOfflineLogPaginationReq nodeOnOfflineLogPaginationReq = new NodeOnOfflineLogPaginationReq();
        nodeOnOfflineLogPaginationReq.setEndLogTime(DateUtils.addDay((Date)new Date(), (int)-30));
        QuietUtils.doWithWarn((Callable)new Callable(){

            public void call() throws Exception {
                LtsAdminDataCleaner.this.appContext.getBackendNodeOnOfflineLogAccess().delete(nodeOnOfflineLogPaginationReq);
            }
        });
        final JvmDataReq jvmDataReq = new JvmDataReq();
        jvmDataReq.setEndTime(DateUtils.addDay((Date)new Date(), (int)-3).getTime());
        QuietUtils.doWithWarn((Callable)new Callable(){

            public void call() throws Exception {
                LtsAdminDataCleaner.this.appContext.getBackendJVMGCAccess().delete(jvmDataReq);
            }
        });
        QuietUtils.doWithWarn((Callable)new Callable(){

            public void call() throws Exception {
                LtsAdminDataCleaner.this.appContext.getBackendJVMThreadAccess().delete(jvmDataReq);
            }
        });
        QuietUtils.doWithWarn((Callable)new Callable(){

            public void call() throws Exception {
                LtsAdminDataCleaner.this.appContext.getBackendJVMMemoryAccess().delete(jvmDataReq);
            }
        });
        LOGGER.info("Clean monitor data succeed ");
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }
}

