/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.support;

import com.github.ltsopensource.admin.support.AppConfigurer;
import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.commons.utils.PlatformUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.compiler.AbstractCompiler;
import com.github.ltsopensource.core.json.JSONFactory;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.monitor.MonitorAgentStartup;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.PropertyConfigurator;

public class SystemInitListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        boolean monitorAgentEnable;
        String log4jPath;
        String confPath = servletContextEvent.getServletContext().getInitParameter("lts.admin.config.path");
        if (StringUtils.isNotEmpty((String[])new String[]{confPath})) {
            System.out.println("lts.admin.config.path : " + confPath);
        }
        AppConfigurer.load(confPath);
        String compiler = AppConfigurer.getProperty("configs.java.compiler");
        if (StringUtils.isNotEmpty((String[])new String[]{compiler})) {
            AbstractCompiler.setCompiler((String)compiler);
        }
        String jsonAdapter = AppConfigurer.getProperty("configs.lts.json");
        if (StringUtils.isNotEmpty((String[])new String[]{jsonAdapter})) {
            JSONFactory.setJSONAdapter((String)jsonAdapter);
        }
        String loggerAdapter = AppConfigurer.getProperty("configs.lts.logger");
        if (StringUtils.isNotEmpty((String[])new String[]{loggerAdapter})) {
            LoggerFactory.setLoggerAdapter((String)loggerAdapter);
        }
        if (FileUtils.exist((String)(log4jPath = confPath + "/log4j.properties"))) {
            PropertyConfigurator.configure((String)log4jPath);
        }
        if (monitorAgentEnable = Boolean.valueOf(AppConfigurer.getProperty("lts.monitorAgent.enable", "true")).booleanValue()) {
            String ltsMonitorCfgPath = confPath;
            if (StringUtils.isEmpty((String)ltsMonitorCfgPath)) {
                ltsMonitorCfgPath = this.getClass().getResource("/").getPath();
                if (PlatformUtils.isWindows()) {
                    ltsMonitorCfgPath = ltsMonitorCfgPath.replaceAll("%20", " ");
                }
            }
            MonitorAgentStartup.start((String)ltsMonitorCfgPath);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        MonitorAgentStartup.stop();
    }
}

