/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.web.api;

import com.github.ltsopensource.admin.cluster.BackendAppContext;
import com.github.ltsopensource.admin.request.JobQueueReq;
import com.github.ltsopensource.admin.response.PaginationRsp;
import com.github.ltsopensource.admin.web.AbstractMVC;
import com.github.ltsopensource.admin.web.support.Builder;
import com.github.ltsopensource.admin.web.vo.RestfulResponse;
import com.github.ltsopensource.biz.logger.JobLogUtils;
import com.github.ltsopensource.biz.logger.JobLogger;
import com.github.ltsopensource.biz.logger.domain.LogType;
import com.github.ltsopensource.core.commons.utils.Assert;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.CronExpression;
import com.github.ltsopensource.core.support.JobUtils;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import java.text.ParseException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CronJobQueueApi
extends AbstractMVC {
    private static final Logger LOGGER = LoggerFactory.getLogger(CronJobQueueApi.class);
    @Autowired
    private BackendAppContext appContext;

    @RequestMapping(value={"/job-queue/cron-job-get"})
    public RestfulResponse cronJobGet(JobQueueReq request) {
        PaginationRsp paginationRsp = this.appContext.getCronJobQueue().pageSelect(request);
        RestfulResponse response = new RestfulResponse();
        response.setSuccess(true);
        response.setResults(paginationRsp.getResults());
        response.setRows(paginationRsp.getRows());
        return response;
    }

    @RequestMapping(value={"/job-queue/cron-job-update"})
    public RestfulResponse cronJobUpdate(JobQueueReq request) {
        RestfulResponse response = new RestfulResponse();
        try {
            Assert.hasLength((String)request.getJobId(), (String)"jobId\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.hasLength((String)request.getCronExpression(), (String)"cronExpression\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        catch (IllegalArgumentException e) {
            return Builder.build(false, e.getMessage());
        }
        try {
            CronExpression expression = new CronExpression(request.getCronExpression());
            Date nextTriggerTime = expression.getTimeAfter(new Date());
            if (nextTriggerTime == null) {
                return Builder.build(false, StringUtils.format((String)"\u8be5CronExpression={} \u5df2\u7ecf\u6ca1\u6709\u6267\u884c\u65f6\u95f4\u70b9! \u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6216\u8005\u76f4\u63a5\u5220\u9664\u3002", (Object[])new Object[]{request.getCronExpression()}));
            }
            JobPo oldJobPo = this.appContext.getCronJobQueue().getJob(request.getJobId());
            boolean success = this.appContext.getCronJobQueue().selectiveUpdateByJobId(request);
            if (success) {
                JobPo newJobPo = this.appContext.getCronJobQueue().getJob(request.getJobId());
                try {
                    boolean cronExpressionChanged;
                    boolean relyOnPrevCycleChanged = !newJobPo.getRelyOnPrevCycle().equals(oldJobPo.getRelyOnPrevCycle());
                    boolean bl = cronExpressionChanged = !newJobPo.getCronExpression().equals(oldJobPo.getCronExpression());
                    if (oldJobPo.getRelyOnPrevCycle().booleanValue() && !relyOnPrevCycleChanged) {
                        if (cronExpressionChanged) {
                            request.setTriggerTime(nextTriggerTime);
                        }
                        this.appContext.getExecutableJobQueue().selectiveUpdateByJobId(request);
                    }
                    if (relyOnPrevCycleChanged) {
                        if (oldJobPo.getRelyOnPrevCycle().booleanValue()) {
                            this.appContext.getExecutableJobQueue().remove(oldJobPo.getTaskTrackerNodeGroup(), oldJobPo.getJobId());
                            this.appContext.getNoRelyJobGenerator().generateCronJobForInterval(newJobPo, new Date());
                        }
                        this.appContext.getExecutableJobQueue().removeBatch(oldJobPo.getRealTaskId(), oldJobPo.getTaskTrackerNodeGroup());
                        newJobPo.setTriggerTime(Long.valueOf(nextTriggerTime.getTime()));
                        try {
                            newJobPo.setInternalExtParam("__LTS_Seq_Id", JobUtils.generateExeSeqId((JobPo)newJobPo));
                            this.appContext.getExecutableJobQueue().add(newJobPo);
                        }
                        catch (DupEntryException ignored) {}
                    }
                    if (cronExpressionChanged) {
                        this.appContext.getExecutableJobQueue().removeBatch(oldJobPo.getRealTaskId(), oldJobPo.getTaskTrackerNodeGroup());
                        this.appContext.getNoRelyJobGenerator().generateCronJobForInterval(newJobPo, new Date());
                    }
                    this.appContext.getExecutableJobQueue().selectiveUpdateByTaskId(request);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return Builder.build(false, "\u66f4\u65b0\u7b49\u5f85\u6267\u884c\u7684\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u66f4\u65b0! error:" + e.getMessage());
                }
            } else {
                return Builder.build(false, "\u8be5\u4efb\u52a1\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u6267\u884c\u5b8c\u6210");
            }
            response.setSuccess(true);
            JobLogUtils.log((LogType)LogType.UPDATE, (JobPo)oldJobPo, (JobLogger)this.appContext.getJobLogger());
            return response;
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Builder.build(false, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 CronExpression!" + e.getMessage());
        }
    }

    @RequestMapping(value={"/job-queue/cron-job-delete"})
    public RestfulResponse cronJobDelete(JobQueueReq request) {
        if (StringUtils.isEmpty((String)request.getJobId())) {
            return Builder.build(false, "JobId \u5fc5\u987b\u4f20!");
        }
        JobPo jobPo = this.appContext.getCronJobQueue().getJob(request.getJobId());
        if (jobPo == null) {
            return Builder.build(true, "\u5df2\u7ecf\u5220\u9664");
        }
        boolean success = this.appContext.getCronJobQueue().remove(request.getJobId());
        if (success) {
            try {
                this.appContext.getExecutableJobQueue().removeBatch(jobPo.getRealTaskId(), jobPo.getTaskTrackerNodeGroup());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return Builder.build(false, "\u5220\u9664\u7b49\u5f85\u6267\u884c\u7684\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5220\u9664! error:{}" + e.getMessage());
            }
        }
        JobLogUtils.log((LogType)LogType.DEL, (JobPo)jobPo, (JobLogger)this.appContext.getJobLogger());
        return Builder.build(true, "ok");
    }

    @RequestMapping(value={"/job-queue/cron-job-suspend"})
    public RestfulResponse cronJobSuspend(JobQueueReq request) {
        if (StringUtils.isEmpty((String)request.getJobId())) {
            return Builder.build(false, "JobId \u5fc5\u987b\u4f20!");
        }
        JobPo jobPo = this.appContext.getCronJobQueue().getJob(request.getJobId());
        if (jobPo == null) {
            return Builder.build(false, "\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5df2\u7ecf\u5220\u9664");
        }
        try {
            jobPo.setGmtModified(Long.valueOf(SystemClock.now()));
            this.appContext.getSuspendJobQueue().add(jobPo);
        }
        catch (DupEntryException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Builder.build(false, "\u8be5\u4efb\u52a1\u5df2\u7ecf\u88ab\u6682\u505c, \u8bf7\u68c0\u67e5\u6682\u505c\u961f\u5217");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Builder.build(false, "\u79fb\u52a8\u4efb\u52a1\u5230\u6682\u505c\u961f\u5217\u5931\u8d25, error:" + e.getMessage());
        }
        try {
            this.appContext.getCronJobQueue().remove(request.getJobId());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Builder.build(false, "\u5220\u9664Cron\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5220\u9664! error:" + e.getMessage());
        }
        try {
            if (!jobPo.getRelyOnPrevCycle().booleanValue()) {
                this.appContext.getCronJobQueue().updateLastGenerateTriggerTime(jobPo.getJobId(), Long.valueOf(new Date().getTime()));
                this.appContext.getExecutableJobQueue().removeBatch(jobPo.getRealTaskId(), jobPo.getTaskTrackerNodeGroup());
            } else {
                this.appContext.getExecutableJobQueue().remove(request.getTaskTrackerNodeGroup(), request.getJobId());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Builder.build(false, "\u5220\u9664\u7b49\u5f85\u6267\u884c\u7684\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5220\u9664! error:" + e.getMessage());
        }
        JobLogUtils.log((LogType)LogType.SUSPEND, (JobPo)jobPo, (JobLogger)this.appContext.getJobLogger());
        return Builder.build(true, "ok");
    }
}

