/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.web.api;

import com.github.ltsopensource.admin.cluster.BackendAppContext;
import com.github.ltsopensource.admin.request.JobQueueReq;
import com.github.ltsopensource.admin.response.PaginationRsp;
import com.github.ltsopensource.admin.support.AppConfigurer;
import com.github.ltsopensource.admin.support.I18nManager;
import com.github.ltsopensource.admin.web.AbstractMVC;
import com.github.ltsopensource.admin.web.support.Builder;
import com.github.ltsopensource.admin.web.vo.RestfulResponse;
import com.github.ltsopensource.biz.logger.domain.JobLoggerRequest;
import com.github.ltsopensource.cmd.DefaultHttpCmd;
import com.github.ltsopensource.cmd.HttpCmd;
import com.github.ltsopensource.cmd.HttpCmdClient;
import com.github.ltsopensource.cmd.HttpCmdResponse;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.Assert;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.domain.Job;
import com.github.ltsopensource.core.domain.Pair;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.support.CronExpression;
import com.github.ltsopensource.queue.domain.JobPo;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JobQueueApi
extends AbstractMVC {
    @Autowired
    private BackendAppContext appContext;

    @RequestMapping(value={"/job-queue/executable-job-get"})
    public RestfulResponse executableJobGet(JobQueueReq request) {
        PaginationRsp<JobPo> paginationRsp = this.appContext.getExecutableJobQueue().pageSelect(request);
        boolean needClear = Boolean.valueOf(AppConfigurer.getProperty("lts.admin.remove.running.job.on.executable.search", "false"));
        if (needClear) {
            paginationRsp = this.clearRunningJob(paginationRsp);
        }
        RestfulResponse response = new RestfulResponse();
        response.setSuccess(true);
        response.setResults(paginationRsp.getResults());
        response.setRows(paginationRsp.getRows());
        return response;
    }

    private PaginationRsp<JobPo> clearRunningJob(PaginationRsp<JobPo> paginationRsp) {
        if (paginationRsp == null || paginationRsp.getResults() == 0) {
            return paginationRsp;
        }
        PaginationRsp rsp = new PaginationRsp();
        ArrayList<JobPo> rows = new ArrayList<JobPo>();
        for (JobPo jobPo : paginationRsp.getRows()) {
            if (this.appContext.getExecutingJobQueue().getJob(jobPo.getTaskTrackerNodeGroup(), jobPo.getTaskId()) != null) continue;
            rows.add(jobPo);
        }
        rsp.setRows(rows);
        rsp.setResults(paginationRsp.getResults() - paginationRsp.getRows().size() - rows.size());
        return rsp;
    }

    @RequestMapping(value={"/job-queue/executing-job-trigger"})
    public RestfulResponse triggerJobManually(JobQueueReq request) {
        try {
            Assert.hasLength((String)request.getJobId(), (String)"jobId\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.hasLength((String)request.getTaskTrackerNodeGroup(), (String)"taskTrackerNodeGroup\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        catch (IllegalArgumentException e) {
            return Builder.build(false, e.getMessage());
        }
        DefaultHttpCmd httpCmd = new DefaultHttpCmd();
        httpCmd.setCommand("trigger_job_manually_cmd");
        httpCmd.addParam("jobId", request.getJobId());
        httpCmd.addParam("nodeGroup", request.getTaskTrackerNodeGroup());
        List<Node> jobTrackerNodeList = this.appContext.getNodeMemCacheAccess().getNodeByNodeType(NodeType.JOB_TRACKER);
        if (CollectionUtils.isEmpty(jobTrackerNodeList)) {
            return Builder.build(false, I18nManager.getMessage("job.tracker.not.found"));
        }
        HttpCmdResponse response = null;
        for (Node node : jobTrackerNodeList) {
            httpCmd.setNodeIdentity(node.getIdentity());
            response = HttpCmdClient.doGet((String)node.getIp(), (int)node.getHttpCmdPort(), (HttpCmd)httpCmd);
            if (!response.isSuccess()) continue;
            return Builder.build(true);
        }
        if (response != null) {
            return Builder.build(false, response.getMsg());
        }
        return Builder.build(false, "TriggerFailed failed");
    }

    @RequestMapping(value={"/job-queue/executing-job-get"})
    public RestfulResponse executingJobGet(JobQueueReq request) {
        PaginationRsp paginationRsp = this.appContext.getExecutingJobQueue().pageSelect(request);
        RestfulResponse response = new RestfulResponse();
        response.setSuccess(true);
        response.setResults(paginationRsp.getResults());
        response.setRows(paginationRsp.getRows());
        return response;
    }

    @RequestMapping(value={"/job-queue/executable-job-update"})
    public RestfulResponse executableJobUpdate(JobQueueReq request) {
        if (StringUtils.isNotEmpty((String[])new String[]{request.getCronExpression()})) {
            try {
                CronExpression expression = new CronExpression(request.getCronExpression());
                if (expression.getTimeAfter(new Date()) == null) {
                    return Builder.build(false, StringUtils.format((String)"\u8be5CronExpression={} \u5df2\u7ecf\u6ca1\u6709\u6267\u884c\u65f6\u95f4\u70b9!", (Object[])new Object[]{request.getCronExpression()}));
                }
            }
            catch (ParseException e) {
                return Builder.build(false, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 CronExpression!");
            }
        }
        try {
            Assert.hasLength((String)request.getJobId(), (String)"jobId\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.hasLength((String)request.getTaskTrackerNodeGroup(), (String)"taskTrackerNodeGroup\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        catch (IllegalArgumentException e) {
            return Builder.build(false, e.getMessage());
        }
        boolean success = this.appContext.getExecutableJobQueue().selectiveUpdateByJobId(request);
        RestfulResponse response = new RestfulResponse();
        if (success) {
            response.setSuccess(true);
        } else {
            response.setSuccess(false);
            response.setCode("DELETE_OR_RUNNING");
        }
        return response;
    }

    @RequestMapping(value={"/job-queue/executable-job-delete"})
    public RestfulResponse executableJobDelete(JobQueueReq request) {
        try {
            Assert.hasLength((String)request.getJobId(), (String)"jobId\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.hasLength((String)request.getTaskTrackerNodeGroup(), (String)"taskTrackerNodeGroup\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        catch (IllegalArgumentException e) {
            return Builder.build(false, e.getMessage());
        }
        boolean success = this.appContext.getExecutableJobQueue().remove(request.getTaskTrackerNodeGroup(), request.getJobId());
        if (success) {
            if (StringUtils.isNotEmpty((String[])new String[]{request.getCronExpression()}) && !"null".equals(request.getCronExpression())) {
                try {
                    this.appContext.getCronJobQueue().remove(request.getJobId());
                }
                catch (Exception e) {
                    return Builder.build(false, "\u5728Cron\u4efb\u52a1\u961f\u5217\u4e2d\u5220\u9664\u8be5\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u66f4\u65b0! error:" + e.getMessage());
                }
            }
            return Builder.build(true);
        }
        return Builder.build(false, "\u66f4\u65b0\u5931\u8d25\uff0c\u8be5\u6761\u4efb\u52a1\u53ef\u80fd\u5df2\u7ecf\u5220\u9664.");
    }

    @RequestMapping(value={"/job-logger/job-logger-get"})
    public RestfulResponse jobLoggerGet(JobLoggerRequest request) {
        RestfulResponse response = new RestfulResponse();
        PaginationRsp paginationRsp = this.appContext.getJobLogger().search(request);
        response.setResults(paginationRsp.getResults());
        response.setRows(paginationRsp.getRows());
        response.setSuccess(true);
        return response;
    }

    @RequestMapping(value={"/job-queue/load-add"})
    public RestfulResponse loadJob(JobQueueReq request) {
        RestfulResponse response = new RestfulResponse();
        String nodeGroup = request.getTaskTrackerNodeGroup();
        DefaultHttpCmd httpCmd = new DefaultHttpCmd();
        httpCmd.setCommand("job_load_cmd");
        httpCmd.addParam("nodeGroup", nodeGroup);
        List<Node> jobTrackerNodeList = this.appContext.getNodeMemCacheAccess().getNodeByNodeType(NodeType.JOB_TRACKER);
        if (CollectionUtils.isEmpty(jobTrackerNodeList)) {
            response.setMsg(I18nManager.getMessage("job.tracker.not.found"));
            response.setSuccess(false);
            return response;
        }
        boolean success = false;
        HttpCmdResponse cmdResponse = null;
        for (Node node : jobTrackerNodeList) {
            httpCmd.setNodeIdentity(node.getIdentity());
            cmdResponse = HttpCmdClient.doGet((String)node.getIp(), (int)node.getHttpCmdPort(), (HttpCmd)httpCmd);
            if (!cmdResponse.isSuccess()) continue;
            success = true;
        }
        if (success) {
            response.setMsg("Load success");
        } else {
            response.setMsg("Load failed");
        }
        response.setSuccess(success);
        return response;
    }

    @RequestMapping(value={"/job-queue/job-add"})
    public RestfulResponse jobAdd(String jobType, JobQueueReq request) {
        block6: {
            try {
                Assert.hasLength((String)request.getTaskId(), (String)I18nManager.getMessage("taskId.not.null"));
                Assert.hasLength((String)request.getTaskTrackerNodeGroup(), (String)"taskTrackerNodeGroup\u4e0d\u80fd\u4e3a\u7a7a!");
                if (request.getNeedFeedback().booleanValue()) {
                    Assert.hasLength((String)request.getSubmitNodeGroup(), (String)"submitNodeGroup\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (!StringUtils.isNotEmpty((String[])new String[]{request.getCronExpression()})) break block6;
                try {
                    CronExpression expression = new CronExpression(request.getCronExpression());
                    Date nextTime = expression.getTimeAfter(new Date());
                    if (nextTime == null) {
                        return Builder.build(false, StringUtils.format((String)"\u8be5CronExpression={} \u5df2\u7ecf\u6ca1\u6709\u6267\u884c\u65f6\u95f4\u70b9!", (Object[])new Object[]{request.getCronExpression()}));
                    }
                    request.setTriggerTime(nextTime);
                }
                catch (ParseException e) {
                    return Builder.build(false, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 CronExpression!");
                }
            }
            catch (IllegalArgumentException e) {
                return Builder.build(false, e.getMessage());
            }
        }
        Pair<Boolean, String> pair = this.addJob(jobType, request);
        return Builder.build((Boolean)pair.getKey(), (String)pair.getValue());
    }

    private Pair<Boolean, String> addJob(String jobType, JobQueueReq request) {
        Job job = new Job();
        job.setTaskId(request.getTaskId());
        if (CollectionUtils.isNotEmpty((Map)request.getExtParams())) {
            for (Map.Entry entry : request.getExtParams().entrySet()) {
                job.setParam((String)entry.getKey(), (String)entry.getValue());
            }
        }
        job.setTaskTrackerNodeGroup(request.getTaskTrackerNodeGroup());
        job.setSubmitNodeGroup(request.getSubmitNodeGroup());
        job.setNeedFeedback(request.getNeedFeedback().booleanValue());
        job.setReplaceOnExist(true);
        job.setCronExpression(request.getCronExpression());
        if (request.getTriggerTime() != null) {
            job.setTriggerTime(Long.valueOf(request.getTriggerTime().getTime()));
        }
        job.setRepeatCount(request.getRepeatCount() == null ? 0 : request.getRepeatCount());
        job.setRepeatInterval(request.getRepeatInterval());
        job.setPriority(request.getPriority());
        job.setMaxRetryTimes(request.getMaxRetryTimes() == null ? 0 : request.getMaxRetryTimes());
        job.setRelyOnPrevCycle(request.getRelyOnPrevCycle() == null ? true : request.getRelyOnPrevCycle());
        if ("REAL_TIME_JOB".equals(jobType)) {
            job.setCronExpression(null);
            job.setTriggerTime(null);
            job.setRepeatInterval(null);
            job.setRepeatCount(0);
            job.setRelyOnPrevCycle(true);
        } else if ("TRIGGER_TIME_JOB".equals(jobType)) {
            job.setCronExpression(null);
            job.setRepeatInterval(null);
            job.setRepeatCount(0);
            job.setRelyOnPrevCycle(true);
        } else if ("CRON_JOB".equals(jobType)) {
            job.setRepeatInterval(null);
            job.setRepeatCount(0);
        } else if ("REPEAT_JOB".equals(jobType)) {
            job.setCronExpression(null);
        }
        return this.addJob(job);
    }

    private Pair<Boolean, String> addJob(Job job) {
        DefaultHttpCmd httpCmd = new DefaultHttpCmd();
        httpCmd.setCommand("job_add_cmd");
        httpCmd.addParam("job", JSON.toJSONString((Object)job));
        List<Node> jobTrackerNodeList = this.appContext.getNodeMemCacheAccess().getNodeByNodeType(NodeType.JOB_TRACKER);
        if (CollectionUtils.isEmpty(jobTrackerNodeList)) {
            return new Pair((Object)false, (Object)I18nManager.getMessage("job.tracker.not.found"));
        }
        HttpCmdResponse response = null;
        for (Node node : jobTrackerNodeList) {
            httpCmd.setNodeIdentity(node.getIdentity());
            response = HttpCmdClient.doGet((String)node.getIp(), (int)node.getHttpCmdPort(), (HttpCmd)httpCmd);
            if (!response.isSuccess()) continue;
            return new Pair((Object)true, (Object)"Add success");
        }
        if (response != null) {
            return new Pair((Object)false, (Object)response.getMsg());
        }
        return new Pair((Object)false, (Object)"Add failed");
    }

    @RequestMapping(value={"/job-queue/executing-job-terminate"})
    public RestfulResponse jobTerminate(String jobId) {
        JobPo jobPo = this.appContext.getExecutingJobQueue().getJob(jobId);
        if (jobPo == null) {
            return Builder.build(false, "\u8be5\u4efb\u52a1\u5df2\u7ecf\u6267\u884c\u5b8c\u6210\u6216\u8005\u88ab\u5220\u9664");
        }
        String taskTrackerIdentity = jobPo.getTaskTrackerIdentity();
        Node node = this.appContext.getNodeMemCacheAccess().getNodeByIdentity(taskTrackerIdentity);
        if (node == null) {
            return Builder.build(false, "\u6267\u884c\u8be5\u4efb\u52a1\u7684TaskTracker\u5df2\u7ecf\u79bb\u7ebf");
        }
        DefaultHttpCmd cmd = new DefaultHttpCmd();
        cmd.setCommand("job_terminate_cmd");
        cmd.setNodeIdentity(taskTrackerIdentity);
        cmd.addParam("jobId", jobId);
        HttpCmdResponse response = HttpCmdClient.doPost((String)node.getIp(), (int)node.getHttpCmdPort(), (HttpCmd)cmd);
        if (response.isSuccess()) {
            return Builder.build(true);
        }
        return Builder.build(false, response.getMsg());
    }
}

