/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.web.api;

import com.github.ltsopensource.admin.cluster.BackendAppContext;
import com.github.ltsopensource.admin.support.I18nManager;
import com.github.ltsopensource.admin.web.AbstractMVC;
import com.github.ltsopensource.admin.web.support.Builder;
import com.github.ltsopensource.admin.web.vo.RestfulResponse;
import com.github.ltsopensource.cmd.DefaultHttpCmd;
import com.github.ltsopensource.cmd.HttpCmd;
import com.github.ltsopensource.cmd.HttpCmdClient;
import com.github.ltsopensource.cmd.HttpCmdResponse;
import com.github.ltsopensource.core.cluster.Node;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jvm"})
public class JvmDataApi
extends AbstractMVC {
    @Autowired
    private BackendAppContext appContext;

    @RequestMapping(value={"node-jvm-info-get"})
    public RestfulResponse getNodeList(String identity) {
        RestfulResponse restfulResponse = new RestfulResponse();
        Node node = this.appContext.getNodeMemCacheAccess().getNodeByIdentity(identity);
        if (node == null) {
            return Builder.build(false, I18nManager.getMessage("node.dose.not.alive"));
        }
        DefaultHttpCmd cmd = new DefaultHttpCmd();
        cmd.setCommand("jvm_info_get_cmd");
        cmd.setNodeIdentity(identity);
        HttpCmdResponse response = HttpCmdClient.doGet((String)node.getIp(), (int)node.getHttpCmdPort(), (HttpCmd)cmd);
        if (response.isSuccess()) {
            restfulResponse.setSuccess(true);
            restfulResponse.setResults(1);
            restfulResponse.setRows(Collections.singletonList(response.getObj()));
        } else {
            restfulResponse.setSuccess(false);
            restfulResponse.setMsg(response.getMsg());
        }
        return restfulResponse;
    }
}

