/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.web.api;

import com.github.ltsopensource.admin.access.domain.NodeOnOfflineLog;
import com.github.ltsopensource.admin.cluster.BackendAppContext;
import com.github.ltsopensource.admin.request.NodeGroupRequest;
import com.github.ltsopensource.admin.request.NodeOnOfflineLogPaginationReq;
import com.github.ltsopensource.admin.request.NodePaginationReq;
import com.github.ltsopensource.admin.response.PaginationRsp;
import com.github.ltsopensource.admin.web.AbstractMVC;
import com.github.ltsopensource.admin.web.vo.RestfulResponse;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.domain.NodeGroupGetReq;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/node"})
public class NodeApi
extends AbstractMVC {
    @Autowired
    private BackendAppContext appContext;

    @RequestMapping(value={"node-list-get"})
    public RestfulResponse getNodeList(NodePaginationReq request) {
        RestfulResponse response = new RestfulResponse();
        request.setLimit(10000);
        PaginationRsp<Node> paginationRsp = this.appContext.getBackendRegistrySrv().getOnlineNodes(request);
        response.setSuccess(true);
        response.setResults(paginationRsp.getResults());
        response.setRows(paginationRsp.getRows());
        return response;
    }

    @RequestMapping(value={"registry-re-subscribe"})
    public RestfulResponse reSubscribe() {
        RestfulResponse response = new RestfulResponse();
        this.appContext.getBackendRegistrySrv().reSubscribe();
        response.setSuccess(true);
        return response;
    }

    @RequestMapping(value={"node-group-get"})
    public RestfulResponse getNodeGroup(NodeGroupGetReq nodeGroupGetReq) {
        RestfulResponse response = new RestfulResponse();
        PaginationRsp paginationRsp = this.appContext.getNodeGroupStore().getNodeGroup(nodeGroupGetReq);
        response.setResults(paginationRsp.getResults());
        response.setRows(paginationRsp.getRows());
        response.setSuccess(true);
        return response;
    }

    @RequestMapping(value={"node-group-add"})
    public RestfulResponse addNodeGroup(NodeGroupRequest request) {
        RestfulResponse response = new RestfulResponse();
        this.appContext.getNodeGroupStore().addNodeGroup(request.getNodeType(), request.getNodeGroup());
        if (NodeType.TASK_TRACKER.equals((Object)request.getNodeType())) {
            this.appContext.getExecutableJobQueue().createQueue(request.getNodeGroup());
        } else if (NodeType.JOB_CLIENT.equals((Object)request.getNodeType())) {
            this.appContext.getJobFeedbackQueue().createQueue(request.getNodeGroup());
        }
        response.setSuccess(true);
        return response;
    }

    @RequestMapping(value={"node-group-del"})
    public RestfulResponse delNodeGroup(NodeGroupRequest request) {
        RestfulResponse response = new RestfulResponse();
        this.appContext.getNodeGroupStore().removeNodeGroup(request.getNodeType(), request.getNodeGroup());
        if (NodeType.TASK_TRACKER.equals((Object)request.getNodeType())) {
            this.appContext.getExecutableJobQueue().removeQueue(request.getNodeGroup());
        } else if (NodeType.JOB_CLIENT.equals((Object)request.getNodeType())) {
            this.appContext.getJobFeedbackQueue().removeQueue(request.getNodeGroup());
        }
        response.setSuccess(true);
        return response;
    }

    @RequestMapping(value={"node-onoffline-log-get"})
    public RestfulResponse getNodeOnofflineLog(NodeOnOfflineLogPaginationReq request) {
        RestfulResponse response = new RestfulResponse();
        Long results = this.appContext.getBackendNodeOnOfflineLogAccess().count(request);
        response.setResults(results.intValue());
        if (results > 0L) {
            List<NodeOnOfflineLog> rows = this.appContext.getBackendNodeOnOfflineLogAccess().select(request);
            response.setRows(rows);
        } else {
            response.setRows(new ArrayList(0));
        }
        response.setSuccess(true);
        return response;
    }
}

