/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.web.api;

import com.github.ltsopensource.admin.cluster.BackendAppContext;
import com.github.ltsopensource.admin.request.JobQueueReq;
import com.github.ltsopensource.admin.response.PaginationRsp;
import com.github.ltsopensource.admin.web.AbstractMVC;
import com.github.ltsopensource.admin.web.support.Builder;
import com.github.ltsopensource.admin.web.vo.RestfulResponse;
import com.github.ltsopensource.biz.logger.JobLogUtils;
import com.github.ltsopensource.biz.logger.JobLogger;
import com.github.ltsopensource.biz.logger.domain.LogType;
import com.github.ltsopensource.core.commons.utils.Assert;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.JobUtils;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RepeatJobQueueApi
extends AbstractMVC {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepeatJobQueueApi.class);
    @Autowired
    private BackendAppContext appContext;

    @RequestMapping(value={"/job-queue/repeat-job-get"})
    public RestfulResponse repeatJobGet(JobQueueReq request) {
        PaginationRsp paginationRsp = this.appContext.getRepeatJobQueue().pageSelect(request);
        RestfulResponse response = new RestfulResponse();
        response.setSuccess(true);
        response.setResults(paginationRsp.getResults());
        response.setRows(paginationRsp.getRows());
        return response;
    }

    @RequestMapping(value={"/job-queue/repeat-job-update"})
    public RestfulResponse repeatJobUpdate(JobQueueReq request) {
        try {
            Assert.hasLength((String)request.getJobId(), (String)"jobId\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.notNull((Object)request.getRepeatInterval(), (String)"repeatInterval\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isTrue((request.getRepeatInterval() > 0L ? 1 : 0) != 0, (String)"repeatInterval\u5fc5\u987b\u5927\u4e8e0");
            Assert.isTrue((request.getRepeatCount() >= -1 ? 1 : 0) != 0, (String)"repeatCount\u5fc5\u987b>= -1");
        }
        catch (IllegalArgumentException e) {
            return Builder.build(false, e.getMessage());
        }
        request.setCronExpression(null);
        JobPo oldJobPo = this.appContext.getRepeatJobQueue().getJob(request.getJobId());
        boolean success = this.appContext.getRepeatJobQueue().selectiveUpdateByJobId(request);
        if (success) {
            try {
                boolean repeatIntervalOrCountDecChanged;
                JobPo newJobPo = this.appContext.getRepeatJobQueue().getJob(request.getJobId());
                boolean relyOnPrevCycleChanged = !newJobPo.getRelyOnPrevCycle().equals(oldJobPo.getRelyOnPrevCycle());
                boolean repeatIntervalChanged = !newJobPo.getRepeatInterval().equals(oldJobPo.getRepeatInterval());
                boolean bl = repeatIntervalOrCountDecChanged = repeatIntervalChanged || oldJobPo.getRepeatCount() == -1 && newJobPo.getRepeatCount() > 0 || oldJobPo.getRepeatCount() != -1 && newJobPo.getRepeatCount() != -1 && newJobPo.getRepeatCount() < oldJobPo.getRepeatCount();
                if (oldJobPo.getRelyOnPrevCycle().booleanValue() && !relyOnPrevCycleChanged) {
                    if (repeatIntervalChanged) {
                        long nextTriggerTime = JobUtils.getRepeatNextTriggerTime((JobPo)oldJobPo);
                        request.setTriggerTime(new Date(nextTriggerTime));
                    }
                    this.appContext.getExecutableJobQueue().selectiveUpdateByJobId(request);
                } else if (relyOnPrevCycleChanged) {
                    if (oldJobPo.getRelyOnPrevCycle().booleanValue()) {
                        this.appContext.getExecutableJobQueue().remove(oldJobPo.getTaskTrackerNodeGroup(), oldJobPo.getJobId());
                        this.appContext.getNoRelyJobGenerator().generateRepeatJobForInterval(newJobPo, new Date());
                    } else {
                        this.appContext.getExecutableJobQueue().removeBatch(oldJobPo.getRealTaskId(), oldJobPo.getTaskTrackerNodeGroup());
                        newJobPo.setTriggerTime(Long.valueOf(JobUtils.getRepeatNextTriggerTime((JobPo)oldJobPo)));
                        try {
                            newJobPo.setInternalExtParam("__LTS_Seq_Id", JobUtils.generateExeSeqId((JobPo)newJobPo));
                            this.appContext.getExecutableJobQueue().add(newJobPo);
                        }
                        catch (DupEntryException ignored) {}
                    }
                } else if (repeatIntervalOrCountDecChanged) {
                    this.appContext.getExecutableJobQueue().removeBatch(oldJobPo.getRealTaskId(), oldJobPo.getTaskTrackerNodeGroup());
                    this.appContext.getNoRelyJobGenerator().generateRepeatJobForInterval(newJobPo, new Date());
                } else {
                    this.appContext.getExecutableJobQueue().selectiveUpdateByTaskId(request);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return Builder.build(false, "\u66f4\u65b0\u7b49\u5f85\u6267\u884c\u7684\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u66f4\u65b0! error:" + e.getMessage());
            }
            JobLogUtils.log((LogType)LogType.UPDATE, (JobPo)oldJobPo, (JobLogger)this.appContext.getJobLogger());
            return Builder.build(true);
        }
        return Builder.build(false, "\u8be5\u4efb\u52a1\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u6267\u884c\u5b8c\u6210");
    }

    @RequestMapping(value={"/job-queue/repeat-job-delete"})
    public RestfulResponse repeatJobDelete(JobQueueReq request) {
        if (StringUtils.isEmpty((String)request.getJobId())) {
            return Builder.build(false, "JobId \u5fc5\u987b\u4f20!");
        }
        JobPo jobPo = this.appContext.getRepeatJobQueue().getJob(request.getJobId());
        boolean success = this.appContext.getRepeatJobQueue().remove(request.getJobId());
        if (success) {
            try {
                this.appContext.getExecutableJobQueue().removeBatch(jobPo.getRealTaskId(), jobPo.getTaskTrackerNodeGroup());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return Builder.build(false, "\u5220\u9664\u7b49\u5f85\u6267\u884c\u7684\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5220\u9664! error:{}" + e.getMessage());
            }
        }
        JobLogUtils.log((LogType)LogType.DEL, (JobPo)jobPo, (JobLogger)this.appContext.getJobLogger());
        return Builder.build(true);
    }

    @RequestMapping(value={"/job-queue/repeat-job-suspend"})
    public RestfulResponse repeatJobSuspend(JobQueueReq request) {
        if (StringUtils.isEmpty((String)request.getJobId())) {
            return Builder.build(false, "JobId \u5fc5\u987b\u4f20!");
        }
        JobPo jobPo = this.appContext.getRepeatJobQueue().getJob(request.getJobId());
        if (jobPo == null) {
            return Builder.build(false, "\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5df2\u7ecf\u5220\u9664");
        }
        try {
            jobPo.setGmtModified(Long.valueOf(SystemClock.now()));
            this.appContext.getSuspendJobQueue().add(jobPo);
        }
        catch (DupEntryException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Builder.build(false, "\u8be5\u4efb\u52a1\u5df2\u7ecf\u88ab\u6682\u505c, \u8bf7\u68c0\u67e5\u6682\u505c\u961f\u5217");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Builder.build(false, "\u79fb\u52a8\u4efb\u52a1\u5230\u6682\u505c\u961f\u5217\u5931\u8d25, error:" + e.getMessage());
        }
        try {
            this.appContext.getRepeatJobQueue().remove(request.getJobId());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Builder.build(false, "\u5220\u9664Repeat\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5220\u9664! error:" + e.getMessage());
        }
        try {
            if (!jobPo.getRelyOnPrevCycle().booleanValue()) {
                this.appContext.getRepeatJobQueue().updateLastGenerateTriggerTime(jobPo.getJobId(), Long.valueOf(new Date().getTime()));
                this.appContext.getExecutableJobQueue().removeBatch(jobPo.getRealTaskId(), jobPo.getTaskTrackerNodeGroup());
            } else {
                this.appContext.getExecutableJobQueue().remove(request.getTaskTrackerNodeGroup(), request.getJobId());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Builder.build(false, "\u5220\u9664\u7b49\u5f85\u6267\u884c\u7684\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u5220\u9664! error:" + e.getMessage());
        }
        JobLogUtils.log((LogType)LogType.SUSPEND, (JobPo)jobPo, (JobLogger)this.appContext.getJobLogger());
        return Builder.build(true);
    }
}

