/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.web.api;

import com.github.ltsopensource.admin.cluster.BackendAppContext;
import com.github.ltsopensource.admin.request.JobQueueReq;
import com.github.ltsopensource.admin.response.PaginationRsp;
import com.github.ltsopensource.admin.web.AbstractMVC;
import com.github.ltsopensource.admin.web.support.Builder;
import com.github.ltsopensource.admin.web.vo.RestfulResponse;
import com.github.ltsopensource.biz.logger.JobLogUtils;
import com.github.ltsopensource.biz.logger.JobLogger;
import com.github.ltsopensource.biz.logger.domain.LogType;
import com.github.ltsopensource.core.commons.utils.Assert;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.CronExpression;
import com.github.ltsopensource.core.support.CronExpressionUtils;
import com.github.ltsopensource.core.support.JobUtils;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import java.text.ParseException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SuspendJobQueueApi
extends AbstractMVC {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuspendJobQueueApi.class);
    @Autowired
    private BackendAppContext appContext;

    @RequestMapping(value={"/job-queue/suspend-job-get"})
    public RestfulResponse suspendJobGet(JobQueueReq request) {
        PaginationRsp paginationRsp = this.appContext.getSuspendJobQueue().pageSelect(request);
        RestfulResponse response = new RestfulResponse();
        response.setSuccess(true);
        response.setResults(paginationRsp.getResults());
        response.setRows(paginationRsp.getRows());
        return response;
    }

    @RequestMapping(value={"/job-queue/suspend-job-update"})
    public RestfulResponse suspendJobUpdate(String jobType, JobQueueReq request) {
        try {
            Assert.hasLength((String)request.getJobId(), (String)"jobId\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.hasLength((String)jobType, (String)"jobType\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        catch (IllegalArgumentException e) {
            return Builder.build(false, e.getMessage());
        }
        try {
            JobPo jobPo = this.appContext.getSuspendJobQueue().getJob(request.getJobId());
            if ("CRON".equals(jobType)) {
                try {
                    Assert.hasLength((String)request.getCronExpression(), (String)"cronExpression\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                catch (IllegalArgumentException e) {
                    return Builder.build(false, e.getMessage());
                }
                CronExpression expression = new CronExpression(request.getCronExpression());
                if (expression.getTimeAfter(new Date()) == null) {
                    return Builder.build(false, StringUtils.format((String)"\u8be5CronExpression={} \u5df2\u7ecf\u6ca1\u6709\u6267\u884c\u65f6\u95f4\u70b9! \u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6216\u8005\u76f4\u63a5\u5220\u9664\u3002", (Object[])new Object[]{request.getCronExpression()}));
                }
                if (!request.getCronExpression().equals(jobPo.getCronExpression())) {
                    request.setTriggerTime(expression.getTimeAfter(new Date()));
                }
            } else {
                try {
                    Assert.notNull((Object)request.getRepeatInterval(), (String)"repeatInterval\u4e0d\u80fd\u4e3a\u7a7a!");
                    Assert.isTrue((request.getRepeatInterval() > 0L ? 1 : 0) != 0, (String)"repeatInterval\u5fc5\u987b\u5927\u4e8e0");
                    Assert.isTrue((request.getRepeatCount() >= -1 ? 1 : 0) != 0, (String)"repeatCount\u5fc5\u987b>= -1");
                }
                catch (IllegalArgumentException e) {
                    return Builder.build(false, e.getMessage());
                }
                if (!request.getRepeatInterval().equals(jobPo.getRepeatInterval())) {
                    long nextTriggerTime = JobUtils.getRepeatNextTriggerTime((JobPo)jobPo);
                    request.setTriggerTime(new Date(nextTriggerTime));
                }
                request.setCronExpression(null);
            }
            boolean success = this.appContext.getSuspendJobQueue().selectiveUpdateByJobId(request);
            if (success) {
                JobLogUtils.log((LogType)LogType.UPDATE, (JobPo)jobPo, (JobLogger)this.appContext.getJobLogger());
                return Builder.build(true);
            }
            return Builder.build(false, "\u8be5\u4efb\u52a1\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u6267\u884c\u5b8c\u6210");
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Builder.build(false, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 CronExpression");
        }
    }

    @RequestMapping(value={"/job-queue/suspend-job-delete"})
    public RestfulResponse suspendJobDelete(JobQueueReq request) {
        if (StringUtils.isEmpty((String)request.getJobId())) {
            return Builder.build(false, "JobId \u5fc5\u987b\u4f20!");
        }
        JobPo jobPo = this.appContext.getSuspendJobQueue().getJob(request.getJobId());
        if (jobPo == null) {
            return Builder.build(true, "\u5df2\u7ecf\u5220\u9664");
        }
        boolean success = this.appContext.getSuspendJobQueue().remove(request.getJobId());
        if (success) {
            JobLogUtils.log((LogType)LogType.DEL, (JobPo)jobPo, (JobLogger)this.appContext.getJobLogger());
        }
        return Builder.build(success);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/job-queue/suspend-job-recovery"})
    public RestfulResponse suspendJobRecovery(JobQueueReq request) {
        if (StringUtils.isEmpty((String)request.getJobId())) {
            return Builder.build(false, "JobId \u5fc5\u987b\u4f20!");
        }
        JobPo jobPo = this.appContext.getSuspendJobQueue().getJob(request.getJobId());
        if (jobPo == null) {
            return Builder.build(false, "\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5df2\u7ecf\u5220\u9664");
        }
        if (jobPo.isCron()) {
            Date nextTriggerTime = CronExpressionUtils.getNextTriggerTime((String)jobPo.getCronExpression());
            if (nextTriggerTime == null) return Builder.build(false, "\u8be5\u4efb\u52a1\u5df2\u7ecf\u65e0\u6548, \u6216\u8005\u5df2\u7ecf\u6ca1\u6709\u4e0b\u4e00\u8f6e\u6267\u884c\u65f6\u95f4\u70b9, \u8bf7\u76f4\u63a5\u5220\u9664");
            jobPo.setGmtModified(Long.valueOf(SystemClock.now()));
            try {
                this.appContext.getCronJobQueue().add(jobPo);
            }
            catch (DupEntryException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return Builder.build(false, "Cron\u961f\u5217\u4e2d\u4efb\u52a1\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return Builder.build(false, "\u63d2\u5165Cron\u961f\u5217\u4e2d\u4efb\u52a1\u9519\u8bef, error:" + e.getMessage());
            }
            if (jobPo.getRelyOnPrevCycle().booleanValue()) {
                try {
                    jobPo.setTriggerTime(Long.valueOf(nextTriggerTime.getTime()));
                    jobPo.setInternalExtParam("__LTS_Seq_Id", JobUtils.generateExeSeqId((JobPo)jobPo));
                    this.appContext.getExecutableJobQueue().add(jobPo);
                }
                catch (DupEntryException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return Builder.build(false, "\u7b49\u5f85\u6267\u884c\u961f\u5217\u4e2d\u4efb\u52a1\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return Builder.build(false, "\u63d2\u5165\u7b49\u5f85\u6267\u884c\u961f\u5217\u4e2d\u4efb\u52a1\u9519\u8bef, error:" + e.getMessage());
                }
            } else {
                this.appContext.getNoRelyJobGenerator().generateCronJobForInterval(jobPo, new Date(SystemClock.now()));
            }
        } else if (jobPo.isRepeatable()) {
            if (jobPo.getRepeatCount() != -1 && jobPo.getRepeatedCount() >= jobPo.getRepeatCount()) return Builder.build(false, "\u8be5\u4efb\u52a1\u5df2\u7ecf\u65e0\u6548, \u6216\u8005\u5df2\u7ecf\u6ca1\u6709\u4e0b\u4e00\u8f6e\u6267\u884c\u65f6\u95f4\u70b9, \u8bf7\u76f4\u63a5\u5220\u9664");
            jobPo.setGmtModified(Long.valueOf(SystemClock.now()));
            try {
                this.appContext.getRepeatJobQueue().add(jobPo);
            }
            catch (DupEntryException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return Builder.build(false, "Repeat\u961f\u5217\u4e2d\u4efb\u52a1\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return Builder.build(false, "\u63d2\u5165Repeat\u961f\u5217\u4e2d\u4efb\u52a1\u9519\u8bef, error:" + e.getMessage());
            }
            if (jobPo.getRelyOnPrevCycle().booleanValue()) {
                try {
                    JobPo repeatJob = this.appContext.getRepeatJobQueue().getJob(request.getJobId());
                    long nextTriggerTime = JobUtils.getRepeatNextTriggerTime((JobPo)repeatJob);
                    jobPo.setTriggerTime(Long.valueOf(nextTriggerTime));
                    jobPo.setInternalExtParam("__LTS_Seq_Id", JobUtils.generateExeSeqId((JobPo)jobPo));
                    this.appContext.getExecutableJobQueue().add(jobPo);
                }
                catch (DupEntryException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return Builder.build(false, "\u7b49\u5f85\u6267\u884c\u961f\u5217\u4e2d\u4efb\u52a1\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return Builder.build(false, "\u63d2\u5165\u7b49\u5f85\u6267\u884c\u961f\u5217\u4e2d\u4efb\u52a1\u9519\u8bef, error:" + e.getMessage());
                }
            } else {
                this.appContext.getNoRelyJobGenerator().generateRepeatJobForInterval(jobPo, new Date(SystemClock.now()));
            }
        }
        if (!this.appContext.getSuspendJobQueue().remove(request.getJobId())) {
            return Builder.build(false, "\u6062\u590d\u6682\u505c\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        JobLogUtils.log((LogType)LogType.RESUME, (JobPo)jobPo, (JobLogger)this.appContext.getJobLogger());
        return Builder.build(true);
    }
}

