/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.web.filter;

import com.github.ltsopensource.admin.support.AppConfigurer;
import com.github.ltsopensource.core.commons.utils.Base64;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.AntPathMatcher;

public class LoginAuthFilter
implements Filter {
    private static final String AUTH_PREFIX = "Basic ";
    private AntPathMatcher pathMatcher = new AntPathMatcher();
    private String username = "admin";
    private String password = "admin";
    private String[] excludedURLArray;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.username = AppConfigurer.getProperty("console.username", this.username);
        this.password = AppConfigurer.getProperty("console.password", this.password);
        String excludedURLs = filterConfig.getInitParameter("excludedURLs");
        if (StringUtils.isNotEmpty((String[])new String[]{excludedURLs})) {
            String[] arr = excludedURLs.split(",");
            this.excludedURLArray = new String[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                this.excludedURLArray[i] = StringUtils.trim((String)arr[i]);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.isExclude(httpRequest.getRequestURI())) {
            chain.doFilter(request, response);
            return;
        }
        String authorization = httpRequest.getHeader("authorization");
        if (null != authorization && authorization.length() > AUTH_PREFIX.length()) {
            authorization = authorization.substring(AUTH_PREFIX.length(), authorization.length());
            if ((this.username + ":" + this.password).equals(new String(Base64.decodeFast((String)authorization)))) {
                this.authenticateSuccess(httpResponse);
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            } else {
                this.needAuthenticate(httpRequest, httpResponse);
            }
        } else {
            this.needAuthenticate(httpRequest, httpResponse);
        }
    }

    private boolean isExclude(String path) {
        if (this.excludedURLArray != null) {
            for (String page : this.excludedURLArray) {
                if (!this.pathMatcher.match(page, path)) continue;
                return true;
            }
        }
        return false;
    }

    private void authenticateSuccess(HttpServletResponse response) {
        response.setStatus(200);
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-store");
        response.setDateHeader("Expires", 0L);
    }

    private void needAuthenticate(HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(401);
        response.setHeader("Cache-Control", "no-store");
        response.setDateHeader("Expires", 0L);
        response.setHeader("WWW-authenticate", "Basic Realm=\"lts admin need auth\"");
    }

    public void destroy() {
    }
}

