/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.web.support;

import com.github.ltsopensource.admin.cluster.BackendAppContext;
import com.github.ltsopensource.queue.CronJobQueue;
import com.github.ltsopensource.queue.ExecutableJobQueue;
import com.github.ltsopensource.queue.RepeatJobQueue;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.queue.support.NonRelyJobUtils;
import java.util.Date;

public class NoRelyJobGenerator {
    private BackendAppContext appContext;
    private int scheduleIntervalMinute;

    public NoRelyJobGenerator(BackendAppContext appContext) {
        this.appContext = appContext;
        this.scheduleIntervalMinute = this.appContext.getConfig().getParameter("jobtracker.nonRelyOnPrevCycleJob.schedule.interval.minute", 10);
    }

    public void generateCronJobForInterval(JobPo jobPo, Date lastGenerateTime) {
        NonRelyJobUtils.addCronJobForInterval((ExecutableJobQueue)this.appContext.getExecutableJobQueue(), (CronJobQueue)this.appContext.getCronJobQueue(), (int)this.scheduleIntervalMinute, (JobPo)jobPo, (Date)lastGenerateTime);
    }

    public void generateRepeatJobForInterval(JobPo jobPo, Date lastGenerateTime) {
        NonRelyJobUtils.addRepeatJobForInterval((ExecutableJobQueue)this.appContext.getExecutableJobQueue(), (RepeatJobQueue)this.appContext.getRepeatJobQueue(), (int)this.scheduleIntervalMinute, (JobPo)jobPo, (Date)lastGenerateTime);
    }
}

