/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.web.support.csrf;

import com.github.ltsopensource.admin.web.support.csrf.CSRFTokenManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.resource.DefaultServletHttpRequestHandler;

public class CSRFHandlerInterceptor
extends HandlerInterceptorAdapter {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestToken;
        if (handler instanceof DefaultServletHttpRequestHandler) {
            return true;
        }
        if (request.getMethod().equalsIgnoreCase("GET")) {
            return true;
        }
        String sessionToken = CSRFTokenManager.getToken(request.getSession());
        if (sessionToken.equals(requestToken = CSRFTokenManager.getToken(request))) {
            return true;
        }
        response.sendError(403, "Bad or missing CSRF value");
        return false;
    }
}

