/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.web.support.csrf;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class CSRFTokenManager {
    static final String CSRF_PARAM_NAME = "csrfToken";
    public static final String CSRF_TOKEN_FOR_SESSION_ATTR_NAME = CSRFTokenManager.class.getSimpleName() + ".token";

    private CSRFTokenManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getToken(HttpSession session) {
        String token = null;
        HttpSession httpSession = session;
        synchronized (httpSession) {
            token = (String)session.getAttribute(CSRF_TOKEN_FOR_SESSION_ATTR_NAME);
            if (null == token) {
                token = UUID.randomUUID().toString();
                session.setAttribute(CSRF_TOKEN_FOR_SESSION_ATTR_NAME, (Object)token);
            }
        }
        return token;
    }

    public static String getToken(HttpServletRequest request) {
        String token = request.getParameter(CSRF_PARAM_NAME);
        if (token == null || "".equals(token)) {
            token = request.getHeader(CSRF_PARAM_NAME);
        }
        return token;
    }
}

