/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.web.support.xss;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final List<Pattern> PATTERNS = new CopyOnWriteArrayList<Pattern>();

    public XssHttpServletRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.cleanXSS(values[i]);
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        if (value == null) {
            return null;
        }
        return this.cleanXSS(value);
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (value == null) {
            return null;
        }
        return this.cleanXSS(value);
    }

    private String cleanXSS(String value) {
        if (value != null) {
            for (Pattern pattern : PATTERNS) {
                value = pattern.matcher(value).replaceAll("");
            }
        }
        return value;
    }

    static {
        PATTERNS.add(Pattern.compile("<script>(.*?)</script>", 2));
        PATTERNS.add(Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42));
        PATTERNS.add(Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42));
        PATTERNS.add(Pattern.compile("</script>", 2));
        PATTERNS.add(Pattern.compile("<script(.*?)>", 42));
        PATTERNS.add(Pattern.compile("eval\\((.*?)\\)", 42));
        PATTERNS.add(Pattern.compile("e\u00adxpression\\((.*?)\\)", 42));
        PATTERNS.add(Pattern.compile("javascript:", 2));
        PATTERNS.add(Pattern.compile("vbscript:", 2));
        PATTERNS.add(Pattern.compile("onload(.*?)=", 42));
    }
}

