/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.web.view;

import com.github.ltsopensource.admin.cluster.BackendAppContext;
import com.github.ltsopensource.biz.logger.domain.LogType;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.DateUtils;
import com.github.ltsopensource.core.constant.Level;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CommonView {
    @Autowired
    private BackendAppContext appContext;

    @RequestMapping(value={"index"})
    public String index() {
        return "index";
    }

    @RequestMapping(value={"node-manager"})
    public String nodeManagerUI() {
        return "nodeManager";
    }

    @RequestMapping(value={"node-group-manager"})
    public String nodeGroupManagerUI() {
        return "nodeGroupManager";
    }

    @RequestMapping(value={"node-onoffline-log"})
    public String nodeOnOfflineLogUI(Model model) {
        model.addAttribute("startLogTime", (Object)DateUtils.formatYMD_HMS((Date)DateUtils.addDay((Date)new Date(), (int)-10)));
        model.addAttribute("endLogTime", (Object)DateUtils.formatYMD_HMS((Date)new Date()));
        return "nodeOnOfflineLog";
    }

    @RequestMapping(value={"node-jvm-info"})
    public String nodeJVMInfo(Model model, String identity) {
        model.addAttribute("identity", (Object)identity);
        return "nodeJvmInfo";
    }

    @RequestMapping(value={"job-add"})
    public String addJobUI(Model model) {
        this.setAttr(model);
        return "jobAdd";
    }

    @RequestMapping(value={"job-logger"})
    public String jobLoggerUI(Model model, String realTaskId, String taskTrackerNodeGroup, Date startLogTime, Date endLogTime) {
        model.addAttribute("realTaskId", (Object)realTaskId);
        model.addAttribute("taskTrackerNodeGroup", (Object)taskTrackerNodeGroup);
        if (startLogTime == null) {
            startLogTime = DateUtils.addMinute((Date)new Date(), (int)-10);
        }
        model.addAttribute("logTypeList", (Object)LogType.values());
        model.addAttribute("logLevelList", (Object)Level.values());
        model.addAttribute("startLogTime", (Object)DateUtils.formatYMD_HMS((Date)startLogTime));
        if (endLogTime == null) {
            endLogTime = new Date();
        }
        model.addAttribute("endLogTime", (Object)DateUtils.formatYMD_HMS((Date)endLogTime));
        this.setAttr(model);
        return "jobLogger";
    }

    @RequestMapping(value={"cron-job-queue"})
    public String cronJobQueueUI(Model model) {
        this.setAttr(model);
        return "cronJobQueue";
    }

    @RequestMapping(value={"repeat-job-queue"})
    public String repeatJobQueueUI(Model model) {
        this.setAttr(model);
        return "repeatJobQueue";
    }

    @RequestMapping(value={"executable-job-queue"})
    public String executableJobQueueUI(Model model) {
        this.setAttr(model);
        return "executableJobQueue";
    }

    @RequestMapping(value={"executing-job-queue"})
    public String executingJobQueueUI(Model model) {
        this.setAttr(model);
        return "executingJobQueue";
    }

    @RequestMapping(value={"load-job"})
    public String loadJobUI(Model model) {
        this.setAttr(model);
        return "loadJob";
    }

    @RequestMapping(value={"cron_generator_iframe"})
    public String cronGeneratorIframe(Model model) {
        return "cron/cronGenerator";
    }

    @RequestMapping(value={"suspend-job-queue"})
    public String suspendJobQueueUI(Model model) {
        this.setAttr(model);
        return "suspendJobQueue";
    }

    private void setAttr(Model model) {
        List jobClientNodeGroups = this.appContext.getNodeGroupStore().getNodeGroup(NodeType.JOB_CLIENT);
        model.addAttribute("jobClientNodeGroups", (Object)jobClientNodeGroups);
        List taskTrackerNodeGroups = this.appContext.getNodeGroupStore().getNodeGroup(NodeType.TASK_TRACKER);
        model.addAttribute("taskTrackerNodeGroups", (Object)taskTrackerNodeGroups);
    }
}

