/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.admin.web.view;

import com.github.ltsopensource.admin.cluster.BackendAppContext;
import com.github.ltsopensource.admin.web.vo.NodeInfo;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.DateUtils;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.queue.domain.NodeGroupPo;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class MonitorView {
    @Autowired
    private BackendAppContext appContext;

    @RequestMapping(value={"monitor/jobtracker-monitor"})
    public String jobTrackerMonitor(Model model) {
        this.initTimeRange(model);
        List<String> taskTrackers = this.appContext.getBackendJobTrackerMAccess().getJobTrackers();
        model.addAttribute("jobTrackers", taskTrackers);
        return "monitor/jobtrackerMonitor";
    }

    @RequestMapping(value={"monitor/tasktracker-monitor"})
    public String taskTrackerMonitor(Model model) {
        this.initTimeRange(model);
        List nodeGroups = this.appContext.getNodeGroupStore().getNodeGroup(NodeType.TASK_TRACKER);
        List<NodeInfo> nodeInfos = this.appContext.getBackendTaskTrackerMAccess().getTaskTrackers();
        this.setGroupIdMap(model, nodeGroups, nodeInfos);
        return "monitor/tasktrackerMonitor";
    }

    @RequestMapping(value={"monitor/jobClient-monitor"})
    public String jobClientMonitor(Model model) {
        this.initTimeRange(model);
        List nodeGroups = this.appContext.getNodeGroupStore().getNodeGroup(NodeType.JOB_CLIENT);
        List<NodeInfo> nodeInfos = this.appContext.getBackendJobClientMAccess().getJobClients();
        this.setGroupIdMap(model, nodeGroups, nodeInfos);
        return "monitor/jobClientMonitor";
    }

    private void initTimeRange(Model model) {
        Date endDate = new Date();
        model.addAttribute("startTime", (Object)DateUtils.formatYMD_HMS((Date)DateUtils.addHour((Date)endDate, (int)-3)));
        model.addAttribute("endTime", (Object)DateUtils.formatYMD_HMS((Date)endDate));
    }

    private void setGroupIdMap(Model model, List<NodeGroupPo> nodeGroups, List<NodeInfo> nodeInfos) {
        HashMap groupIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(nodeGroups)) {
            for (NodeGroupPo nodeGroup : nodeGroups) {
                groupIdMap.put(nodeGroup.getName(), new HashSet());
            }
            if (CollectionUtils.isNotEmpty(nodeInfos)) {
                for (NodeInfo nodeInfo : nodeInfos) {
                    HashSet<String> identities = (HashSet<String>)groupIdMap.get(nodeInfo.getNodeGroup());
                    if (identities == null) {
                        identities = new HashSet<String>();
                        groupIdMap.put(nodeInfo.getNodeGroup(), identities);
                    }
                    identities.add(nodeInfo.getIdentity());
                }
            }
        }
        model.addAttribute("groupIdMap", (Object)JSON.toJSONString(groupIdMap));
    }
}

