/*
 * Decompiled with CFR 0.152.
 */
package com.ijz.framework.export.excel.exports;

import com.ijz.framework.export.excel.exports.definition.ExportDefinition;
import com.ijz.framework.export.excel.exports.definition.LabelDefinition;
import com.ijz.framework.export.excel.exports.definition.PropertyDefinition;
import com.ijz.framework.export.excel.exports.definition.TitleDefinition;
import com.ijz.framework.export.excel.exports.query.PageQuery;
import com.ijz.framework.export.excel.exports.query.QueryModel;
import com.ijz.framework.export.excel.exports.themestyle.StyleFunction;
import com.ijz.framework.export.excel.exports.themestyle.StyleFunctionFactory;
import com.ijz.framework.export.exception.ExportException;
import com.ijz.framework.export.utils.CollectionUtils;
import com.ijz.framework.export.utils.ReflectUtils;
import com.ijz.framework.export.utils.StringUtils;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.jxls.common.Context;
import org.jxls.util.JxlsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelExportUtils.class);

    public static void export(HttpServletResponse response, String fileName, List<?> dataList, ExportDefinition definition) {
        ExcelExportUtils.setResponse(response, fileName, "xlsx", true);
        try {
            ExcelExportUtils.export((OutputStream)response.getOutputStream(), dataList, definition);
        }
        catch (IOException e) {
            throw new ExportException("\u83b7\u53d6response\u5bf9\u8c61\u7684\u8f93\u51fa\u6d41\u5f02\u5e38", e);
        }
    }

    public static void export(OutputStream outputStream, List<?> dataList, ExportDefinition definition) {
        if (definition == null) {
            throw new ExportException("\u5bfc\u51fa\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u672a\u7a7a");
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook(definition.getWindowSize());
        workbook.setCompressTempFiles(definition.isCompress());
        ExcelExportUtils.writeWorkbook(workbook, Optional.ofNullable(dataList).orElse(new ArrayList()), definition);
        try {
            workbook.write(outputStream);
        }
        catch (IOException e) {
            throw new ExportException("\u5199\u5165\u8f93\u51fa\u6d41\u5f02\u5e38", e);
        }
        ExcelExportUtils.closeOutputStream(workbook, outputStream);
    }

    private static void writeWorkbook(SXSSFWorkbook workbook, List<?> dataList, ExportDefinition definition) {
        int sheetSize = 0x100000 - definition.getDataBeginRowIndex();
        int sheetNum = dataList.size() == 0 ? 1 : (dataList.size() % sheetSize == 0 ? dataList.size() / sheetSize : dataList.size() / sheetSize + 1);
        IntStream.range(0, sheetNum).forEach(index -> ExcelExportUtils.writeSheet(workbook, definition, dataList.stream().skip(index * sheetSize).limit(sheetSize).collect(Collectors.toList()), index));
    }

    private static void writeSheet(SXSSFWorkbook workbook, ExportDefinition definition, List<?> dataList, int sheetIndex) {
        StyleFunctionFactory styleFunctionFactory = definition.getStyleFunctionFactory();
        StyleFunction titleStyleFunction = styleFunctionFactory.getTitleStyleFunction();
        StyleFunction headerStyleFunction = styleFunctionFactory.getHeaderStyleFunction();
        StyleFunction dataStyleFunction = styleFunctionFactory.getDataStyleFunction();
        SXSSFSheet sheet = StringUtils.isEmpty(definition.getSheetName()) ? workbook.createSheet() : workbook.createSheet(definition.getSheetName() + (sheetIndex == 0 ? "" : "(" + (sheetIndex + 1) + ")"));
        ExcelExportUtils.writeTitle((Sheet)sheet, definition.getTitle(), (CellStyle)titleStyleFunction.apply(workbook));
        ExcelExportUtils.writeHeader(workbook, (Sheet)sheet, definition.getLabels(), (CellStyle)headerStyleFunction.apply(workbook), definition.getHeaderBeginRowIndex(), definition.getHeaderHeight());
        ExcelExportUtils.writeData(workbook, (Sheet)sheet, definition.getProperties(), (CellStyle)dataStyleFunction.apply(workbook), dataList, definition.getDataBeginRowIndex());
    }

    private static void writeTitle(Sheet sheet, TitleDefinition definition, CellStyle cellStyle) {
        if (definition != null) {
            Row titleRow = sheet.createRow(0);
            Cell cell = titleRow.createCell(0);
            cell.setCellValue(definition.getName());
            cell.setCellStyle(cellStyle);
            sheet.addMergedRegion(new CellRangeAddress(0, definition.getHeight() - 1, 0, definition.getWidth() - 1));
        }
    }

    private static void writeHeader(SXSSFWorkbook workbook, Sheet sheet, List<LabelDefinition> definitions, CellStyle cellStyle, int rowIndex, int headerHeight) {
        IntStream.range(0, headerHeight).forEach(index -> sheet.createRow(rowIndex + index));
        ExcelExportUtils.writeLabels(workbook, sheet, definitions, cellStyle, rowIndex, rowIndex + headerHeight, 0);
    }

    private static void writeLabels(SXSSFWorkbook workbook, Sheet sheet, List<LabelDefinition> definitions, CellStyle cellStyle, int rowIndex, int endRowIndex, int cellIndex) {
        if (!CollectionUtils.isEmpty(definitions)) {
            for (LabelDefinition definition : definitions) {
                Cell cell = sheet.getRow(rowIndex).createCell(cellIndex);
                cell.setCellValue(definition.isRequired() ? "*" + definition.getName() : definition.getName());
                cell.setCellStyle(definition.getStyleFunction() == null ? cellStyle : (CellStyle)definition.getStyleFunction().apply(workbook));
                if (CollectionUtils.isEmpty(definition.getChildren())) {
                    if (endRowIndex > rowIndex + 1) {
                        sheet.addMergedRegion(new CellRangeAddress(rowIndex, endRowIndex - 1, cellIndex, cellIndex));
                    }
                } else {
                    sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, cellIndex, cellIndex + definition.getWidth() - 1));
                    ExcelExportUtils.writeLabels(workbook, sheet, definition.getChildren(), cellStyle, rowIndex + 1, endRowIndex, cellIndex);
                }
                cellIndex += definition.getWidth();
            }
        }
    }

    private static void writeData(SXSSFWorkbook workbook, Sheet sheet, List<PropertyDefinition> definitions, CellStyle cellStyle, List<?> dataList, int rowIndex) {
        if (!CollectionUtils.isEmpty(dataList)) {
            IntStream.range(0, dataList.size()).forEach(dataIndex -> {
                Object data = dataList.get(dataIndex);
                Row row = sheet.createRow(rowIndex + dataIndex);
                IntStream.range(0, definitions.size()).forEach(cellIndex -> {
                    PropertyDefinition definition = (PropertyDefinition)definitions.get(cellIndex);
                    Cell cell = row.createCell(cellIndex);
                    Object value = ReflectUtils.getFieldValueWithName(data, definition.getName());
                    if (definition.getStyleFunction() != null) {
                        cell.setCellStyle(definition.getStyleFunction().apply(workbook, value));
                    } else {
                        cell.setCellStyle(cellStyle);
                    }
                    if (definition.getValueFunction() != null) {
                        value = definition.getValueFunction().apply(value);
                    }
                    cell.setCellValue(value == null ? "" : String.valueOf(value));
                });
            });
        }
    }

    private static void closeOutputStream(SXSSFWorkbook workbook, OutputStream out) {
        try {
            workbook.close();
            out.close();
            workbook.dispose();
        }
        catch (IOException e) {
            throw new ExportException("\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38", e);
        }
    }

    public static void batchExport(HttpServletResponse response, String fileName, List<List<?>> dataList, List<ExportDefinition> definitions) {
        ExcelExportUtils.setResponse(response, fileName, "xlsx", true);
        try {
            ExcelExportUtils.batchExport((OutputStream)response.getOutputStream(), dataList, definitions);
        }
        catch (IOException e) {
            throw new ExportException("\u83b7\u53d6response\u5bf9\u8c61\u7684\u8f93\u51fa\u6d41\u5f02\u5e38", e);
        }
    }

    public static void batchExport(OutputStream outputStream, List<List<?>> dataList, List<ExportDefinition> definitions) {
        if (CollectionUtils.isEmpty(definitions)) {
            throw new ExportException("\u5bfc\u51fa\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u672a\u7a7a");
        }
        if (dataList != null && dataList.size() != definitions.size()) {
            throw new ExportException("\u5bfc\u51fa\u6570\u636e\u4e0e\u5176\u5bfc\u51fa\u5b9a\u4e49\u672a\u4e00\u4e00\u5bf9\u5e94");
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook(definitions.get(0).getWindowSize());
        workbook.setCompressTempFiles(definitions.get(0).isCompress());
        if (!CollectionUtils.isEmpty(dataList)) {
            IntStream.range(0, dataList.size()).forEach(index -> ExcelExportUtils.writeWorkbook(workbook, (List)dataList.get(index), (ExportDefinition)definitions.get(index)));
        }
        try {
            workbook.write(outputStream);
        }
        catch (IOException e) {
            throw new ExportException("\u5bfc\u51faexcel\u5f02\u5e38", e);
        }
        ExcelExportUtils.closeOutputStream(workbook, outputStream);
    }

    public static void packageExport(HttpServletResponse response, String fileName, List<?> dataList, ExportDefinition definition) {
        ExcelExportUtils.setResponse(response, fileName, "zip", true);
        try {
            ExcelExportUtils.packageExport((OutputStream)response.getOutputStream(), dataList, definition);
        }
        catch (IOException e) {
            throw new ExportException("\u83b7\u53d6response\u5bf9\u8c61\u7684\u8f93\u51fa\u6d41\u5f02\u5e38", e);
        }
    }

    public static void packageExport(OutputStream outputStream, List<?> dataList, ExportDefinition definition) {
        if (definition == null) {
            throw new ExportException("\u5bfc\u51fa\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u672a\u7a7a");
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));
        if (!CollectionUtils.isEmpty(dataList)) {
            int excelNumber = dataList.size() % definition.getPackageSize() == 0 ? dataList.size() / definition.getPackageSize() : dataList.size() / definition.getPackageSize() + 1;
            IntStream.range(0, excelNumber).forEach(index -> {
                ZipEntry zipEntry = new ZipEntry(String.format("part%s.xlsx", index + 1));
                try {
                    zipOutputStream.putNextEntry(zipEntry);
                }
                catch (IOException e) {
                    throw new ExportException("\u65b0\u5efaentry\u5f02\u5e38", e);
                }
                SXSSFWorkbook workbook = ExcelExportUtils.createWorkbook(dataList.stream().skip(index * definition.getPackageSize()).limit(definition.getPackageSize()).collect(Collectors.toList()), definition);
                try {
                    workbook.write((OutputStream)zipOutputStream);
                }
                catch (IOException e) {
                    throw new ExportException("\u5199\u5165\u8f93\u51fa\u6d41\u5f02\u5e38", e);
                }
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    throw new ExportException("\u5173\u95ed\u5de5\u4f5c\u7c3f\u5f02\u5e38", e);
                }
                workbook.dispose();
                try {
                    zipOutputStream.closeEntry();
                }
                catch (IOException e) {
                    throw new ExportException("\u5173\u95edentry\u5f02\u5e38", e);
                }
            });
        }
        try {
            zipOutputStream.close();
            outputStream.close();
        }
        catch (IOException e) {
            throw new ExportException("\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38", e);
        }
    }

    private static SXSSFWorkbook createWorkbook(List<?> dataList, ExportDefinition definition) {
        SXSSFWorkbook workbook = new SXSSFWorkbook(definition.getWindowSize());
        workbook.setCompressTempFiles(definition.isCompress());
        ExcelExportUtils.writeWorkbook(workbook, dataList, definition);
        return workbook;
    }

    public static void exportByTemplate(HttpServletResponse response, String fileName, String templatePath, Map<String, Object> model) {
        ExcelExportUtils.setResponse(response, fileName, "xlsx", false);
        try {
            ExcelExportUtils.exportByTemplate((OutputStream)response.getOutputStream(), templatePath, model);
        }
        catch (IOException e) {
            throw new ExportException("\u83b7\u53d6response\u5bf9\u8c61\u7684\u8f93\u51fa\u6d41\u5f02\u5e38", e);
        }
    }

    public static void exportByTemplate(OutputStream outputStream, String templatePath, Map<String, Object> model) {
        FileInputStream inputStream;
        String path;
        Context context = new Context();
        if (model != null && model.size() > 0) {
            model.forEach((arg_0, arg_1) -> ((Context)context).putVar(arg_0, arg_1));
        }
        try {
            path = ExcelExportUtils.class.getClassLoader().getResource(templatePath).toURI().getPath();
        }
        catch (URISyntaxException e) {
            throw new ExportException(String.format("\u627e\u4e0d\u5230excel\u6a21\u677f\uff0ctemplatePath\uff1a%s", templatePath), e);
        }
        try {
            inputStream = new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            throw new ExportException(String.format("\u627e\u4e0d\u5230excel\u6a21\u677f\uff0c\u6a21\u677f\u5730\u5740\uff1a%s", path), e);
        }
        try {
            JxlsHelper.getInstance().processTemplate((InputStream)inputStream, outputStream, context);
        }
        catch (IOException e) {
            throw new ExportException("\u5bfc\u51faexcel\u6a21\u677f\u5f02\u5e38", e);
        }
    }

    private static void setResponse(HttpServletResponse response, String fileName, String fileSuffix, boolean stream) {
        if (StringUtils.isEmpty(fileName)) {
            try {
                fileName = URLEncoder.encode(fileName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error(String.format("\u5b57\u7b26\u7f16\u7801\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff0c\u539f\u5b57\u7b26\uff1a%s", fileName));
                fileName = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            }
        }
        response.setHeader("Content-Disposition", String.format("attachment;filename=%s.%s", fileName, fileSuffix));
        if (stream) {
            response.setContentType("xlsx".equals(fileSuffix) ? "application/octet-stream; charset=utf-8" : "application/x-zip-compressed; charset=utf-8");
        } else {
            response.setContentType("xlsx".equals(fileSuffix) ? "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; charset=utf-8" : "application/x-zip-compressed; charset=utf-8");
        }
        response.setCharacterEncoding("utf-8");
    }

    public static void export(HttpServletResponse response, String fileName, QueryModel queryModel, ExportDefinition definition) {
        ExcelExportUtils.setResponse(response, fileName, "xlsx", true);
        try {
            ExcelExportUtils.export((OutputStream)response.getOutputStream(), queryModel, definition);
        }
        catch (IOException e) {
            throw new ExportException("\u83b7\u53d6response\u5bf9\u8c61\u7684\u8f93\u51fa\u6d41\u5f02\u5e38", e);
        }
    }

    public static void export(OutputStream outputStream, QueryModel queryModel, ExportDefinition definition) {
        if (queryModel == null) {
            throw new ExportException("\u67e5\u8be2\u6a21\u578b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (definition == null) {
            throw new ExportException("\u5bfc\u51fa\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u672a\u7a7a");
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook(definition.getWindowSize());
        workbook.setCompressTempFiles(definition.isCompress());
        ExcelExportUtils.writeSheets(workbook, definition, queryModel, 0);
        try {
            workbook.write(outputStream);
        }
        catch (IOException e) {
            throw new ExportException("\u5199\u5165\u8f93\u51fa\u6d41\u5f02\u5e38", e);
        }
        ExcelExportUtils.closeOutputStream(workbook, outputStream);
    }

    private static void writeSheets(SXSSFWorkbook workbook, ExportDefinition definition, QueryModel queryModel, int sheetIndex) {
        StyleFunctionFactory styleFunctionFactory = definition.getStyleFunctionFactory();
        StyleFunction titleStyleFunction = styleFunctionFactory.getTitleStyleFunction();
        StyleFunction headerStyleFunction = styleFunctionFactory.getHeaderStyleFunction();
        SXSSFSheet sheet = StringUtils.isEmpty(definition.getSheetName()) ? workbook.createSheet() : workbook.createSheet(definition.getSheetName() + (sheetIndex == 0 ? "" : "(" + (sheetIndex + 1) + ")"));
        ExcelExportUtils.writeTitle((Sheet)sheet, definition.getTitle(), (CellStyle)titleStyleFunction.apply(workbook));
        ExcelExportUtils.writeHeader(workbook, (Sheet)sheet, definition.getLabels(), (CellStyle)headerStyleFunction.apply(workbook), definition.getHeaderBeginRowIndex(), definition.getHeaderHeight());
        int sheetSize = 0x100000 - definition.getDataBeginRowIndex();
        int queryNumber = sheetSize / queryModel.getPageQuery().getPageSize();
        ExcelExportUtils.writeQueryData(workbook, sheet, definition, queryModel, queryNumber, sheetIndex);
    }

    private static void writeQueryData(SXSSFWorkbook workbook, SXSSFSheet sheet, ExportDefinition definition, QueryModel queryModel, int queryNumber, int sheetIndex) {
        PageQuery pageQuery = queryModel.getPageQuery();
        for (int index = 0; index < queryNumber; ++index) {
            List dataList = (List)queryModel.getQueryFunction().apply(pageQuery);
            if (CollectionUtils.isEmpty(dataList)) continue;
            ExcelExportUtils.writeData(workbook, (Sheet)sheet, definition.getProperties(), (CellStyle)definition.getStyleFunctionFactory().getDataStyleFunction().apply(workbook), dataList, definition.getDataBeginRowIndex() + index * pageQuery.getPageSize());
            pageQuery.setId((Long)ReflectUtils.getFieldValueWithName(dataList.get(dataList.size() - 1), pageQuery.getIdName()));
            if (dataList.size() != pageQuery.getPageSize()) break;
            if (index != queryNumber - 1) continue;
            ExcelExportUtils.writeSheets(workbook, definition, queryModel, sheetIndex + 1);
        }
    }
}

