/*
 * Decompiled with CFR 0.152.
 */
package com.ijz.framework.export.excel.exports.definition;

import com.ijz.framework.export.excel.exports.definition.LabelDefinition;
import com.ijz.framework.export.excel.exports.definition.PropertyDefinition;
import com.ijz.framework.export.excel.exports.definition.TitleDefinition;
import com.ijz.framework.export.excel.exports.themestyle.DefaultStyleFunctionFactory;
import com.ijz.framework.export.excel.exports.themestyle.StyleFunctionFactory;
import com.ijz.framework.export.exception.ExportException;
import com.ijz.framework.export.utils.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;

public class ExportDefinition {
    public static final int MAX_ROW = 0x100000;
    private String sheetName;
    private TitleDefinition title;
    private List<LabelDefinition> labels;
    private List<PropertyDefinition> properties;
    private List<ExportDefinition> childrenDefinitions;
    private StyleFunctionFactory styleFunctionFactory;
    private int windowSize;
    private boolean compress;
    private int packageSize;

    private ExportDefinition(Builder builder) {
        this.sheetName = builder.sheetName;
        this.title = builder.title;
        this.labels = builder.labels;
        this.properties = builder.properties;
        this.childrenDefinitions = builder.childrenDefinitions;
        this.styleFunctionFactory = builder.styleFunctionFactory;
        this.windowSize = builder.windowSize;
        this.compress = builder.compress;
        this.packageSize = builder.packageSize;
        if (this.title != null) {
            this.title.setWidth(this.properties.size());
        }
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public TitleDefinition getTitle() {
        return this.title;
    }

    public List<LabelDefinition> getLabels() {
        return this.labels;
    }

    public List<PropertyDefinition> getProperties() {
        return this.properties;
    }

    public List<ExportDefinition> getChildrenDefinitions() {
        return this.childrenDefinitions;
    }

    public StyleFunctionFactory getStyleFunctionFactory() {
        return this.styleFunctionFactory;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public int getPackageSize() {
        return this.packageSize;
    }

    public int getHeaderHeight() {
        return this.labels.stream().map(LabelDefinition::getHeight).max(Integer::compareTo).orElse(0);
    }

    public int getHeaderWidth() {
        return this.labels.stream().map(LabelDefinition::getWidth).max(Integer::compareTo).orElse(0);
    }

    public int getHeaderBeginRowIndex() {
        return this.getTitle() == null ? 0 : this.getTitle().getHeight() + 1;
    }

    public int getDataBeginRowIndex() {
        return this.getHeaderBeginRowIndex() + this.getHeaderHeight();
    }

    public static class Builder {
        private String sheetName;
        private TitleDefinition title;
        private List<LabelDefinition> labels;
        private List<PropertyDefinition> properties;
        private List<ExportDefinition> childrenDefinitions;
        private StyleFunctionFactory styleFunctionFactory = new DefaultStyleFunctionFactory();
        private int windowSize = 100;
        private boolean compress;
        private int packageSize = 200000;

        public Builder sheetName(String sheetName) {
            this.sheetName = sheetName;
            return this;
        }

        public Builder title(TitleDefinition title) {
            this.title = title;
            return this;
        }

        public Builder labels(List<LabelDefinition> labels) {
            this.labels = labels;
            return this;
        }

        public Builder properties(List<PropertyDefinition> properties) {
            this.properties = properties;
            return this;
        }

        public Builder childrenDefinitions(List<ExportDefinition> childrenDefinitions) {
            this.childrenDefinitions = childrenDefinitions;
            return this;
        }

        public Builder styleFunctionFactory(StyleFunctionFactory functionFactory) {
            this.styleFunctionFactory = functionFactory;
            return this;
        }

        public Builder windowSize(int windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public Builder compress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public Builder packageSize(int packageSize) {
            this.packageSize = packageSize;
            return this;
        }

        public Builder simpleTitle(String title) {
            this.title = new TitleDefinition.Builder().name(title).height(1).build();
            return this;
        }

        public Builder simpleLabels(List<String> labels) {
            this.labels = labels.stream().map(label -> new LabelDefinition.Builder().name((String)label).build()).collect(Collectors.toList());
            return this;
        }

        public Builder simpleProperties(List<String> properties) {
            this.properties = properties.stream().map(property -> new PropertyDefinition.Builder().name((String)property).build()).collect(Collectors.toList());
            return this;
        }

        public ExportDefinition build() {
            if (!CollectionUtils.isEmpty(this.properties) && !CollectionUtils.isEmpty(this.labels) && this.properties.size() != this.labels.stream().map(LabelDefinition::getWidth).reduce((pre, cur) -> pre + cur).orElse(0).intValue()) {
                throw new ExportException("labels\u5c5e\u6027\u4e0eproperties\u5c5e\u6027\u672a\u4e00\u4e00\u5bf9\u5e94");
            }
            return new ExportDefinition(this);
        }
    }
}

