/*
 * Decompiled with CFR 0.152.
 */
package com.ijz.framework.export.excel.exports.definition;

import com.ijz.framework.export.excel.exports.themestyle.RequiredStyleFunction;
import com.ijz.framework.export.excel.exports.themestyle.StyleFunction;
import com.ijz.framework.export.utils.CollectionUtils;
import java.util.List;

public class LabelDefinition {
    private String name;
    private StyleFunction styleFunction;
    private List<LabelDefinition> children;
    private boolean required;

    private LabelDefinition(Builder builder) {
        this.name = builder.name;
        this.styleFunction = builder.styleFunction;
        this.children = builder.children;
        this.required = builder.required;
        if (this.styleFunction == null && builder.required) {
            this.styleFunction = new RequiredStyleFunction();
        }
    }

    public String getName() {
        return this.name;
    }

    public StyleFunction getStyleFunction() {
        return this.styleFunction;
    }

    public List<LabelDefinition> getChildren() {
        return this.children;
    }

    public boolean isRequired() {
        return this.required;
    }

    public int getWidth() {
        return this.getWidth(this.children);
    }

    private int getWidth(List<LabelDefinition> children) {
        if (CollectionUtils.isEmpty(children)) {
            return 1;
        }
        return children.stream().map(item -> this.getWidth(item.getChildren())).reduce((pre, cur) -> pre + cur).orElse(0);
    }

    public int getHeight() {
        return this.getHeight(this.children);
    }

    private int getHeight(List<LabelDefinition> children) {
        if (CollectionUtils.isEmpty(children)) {
            return 1;
        }
        return 1 + children.stream().map(item -> this.getHeight(item.getChildren())).max(Integer::compareTo).orElse(0);
    }

    public static class Builder {
        private String name;
        private StyleFunction styleFunction;
        private List<LabelDefinition> children;
        private boolean required;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder styleFunction(StyleFunction style) {
            this.styleFunction = style;
            return this;
        }

        public Builder children(List<LabelDefinition> children) {
            this.children = children;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public LabelDefinition build() {
            return new LabelDefinition(this);
        }
    }
}

