/*
 * Decompiled with CFR 0.152.
 */
package com.ijz.framework.export.excel.exports.definition;

import com.ijz.framework.export.exception.ExportException;
import com.ijz.framework.export.utils.StringUtils;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class PropertyDefinition {
    private String name;
    private Function valueFunction;
    private BiFunction<SXSSFWorkbook, Object, CellStyle> styleFunction;

    private PropertyDefinition(Builder builder) {
        this.name = builder.name;
        this.valueFunction = builder.valueFunction;
        this.styleFunction = builder.styleFunction;
    }

    public String getName() {
        return this.name;
    }

    public Function getValueFunction() {
        return this.valueFunction;
    }

    public BiFunction<SXSSFWorkbook, Object, CellStyle> getStyleFunction() {
        return this.styleFunction;
    }

    public static class Builder {
        private String name;
        private Function valueFunction;
        private BiFunction<SXSSFWorkbook, Object, CellStyle> styleFunction;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder valueFunction(Function valueFunction) {
            this.valueFunction = valueFunction;
            return this;
        }

        public Builder styleFunction(BiFunction<SXSSFWorkbook, Object, CellStyle> styleFunction) {
            this.styleFunction = styleFunction;
            return this;
        }

        public PropertyDefinition build() {
            if (StringUtils.isEmpty(this.name)) {
                throw new ExportException("\u5c5e\u6027\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return new PropertyDefinition(this);
        }
    }
}

