/*
 * Decompiled with CFR 0.152.
 */
package com.ijz.framework.export.excel.imports;

import com.ijz.framework.export.excel.imports.definition.ColumnDefinition;
import com.ijz.framework.export.excel.imports.definition.ImportDefinition;
import com.ijz.framework.export.exception.ExportException;
import com.ijz.framework.export.exception.ImportException;
import com.ijz.framework.export.utils.CollectionUtils;
import com.ijz.framework.export.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConversionException;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelImportUtils {
    public static <T> List<T> imports(InputStream inputStream, ImportDefinition<T> definition) {
        XSSFWorkbook workbook;
        if (definition == null) {
            throw new ExportException("\u5bfc\u51fa\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u672a\u7a7a");
        }
        try {
            workbook = new XSSFWorkbook(inputStream);
        }
        catch (IOException e) {
            throw new ImportException("\u5b9e\u4f8b\u5316Workbook\u5f02\u5e38", e);
        }
        List<T> dataList = ExcelImportUtils.readData(workbook, definition, 0);
        ExcelImportUtils.closeInputStream(workbook, inputStream);
        return dataList;
    }

    private static <T> List<T> readData(XSSFWorkbook workbook, ImportDefinition<T> definition, int sheetIndex) {
        XSSFSheet sheet = StringUtils.isEmpty(definition.getSheetName()) ? workbook.getSheetAt(sheetIndex) : workbook.getSheet(definition.getSheetName());
        return ExcelImportUtils.readSheet((Sheet)sheet, definition, definition.getStartIndex(), sheet.getLastRowNum(), definition.isParallel(), definition.getThreadNumber());
    }

    private static <T> List<T> readSheet(Sheet sheet, ImportDefinition<T> definition, int beginRow, int endRow, boolean parallel, int threadNumber) {
        if (parallel) {
            ExecutorService executorService = Executors.newFixedThreadPool(threadNumber);
            ExecutorCompletionService completionService = new ExecutorCompletionService(executorService);
            IntStream.range(beginRow, endRow + 1).forEach(rowIndex -> completionService.submit(() -> ExcelImportUtils.readRow(sheet, definition, rowIndex)));
            ArrayList dataList = new ArrayList();
            IntStream.range(beginRow, endRow + 1).forEach(index -> {
                try {
                    dataList.add(completionService.take().get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException("\u5bfc\u5165\u5f02\u5e38", e);
                }
            });
            executorService.shutdown();
            return dataList;
        }
        return IntStream.range(beginRow, endRow + 1).mapToObj(rowIndex -> ExcelImportUtils.readRow(sheet, definition, rowIndex)).collect(Collectors.toList());
    }

    private static <T> T readRow(Sheet sheet, ImportDefinition<T> definition, int rowIndex) {
        Object model;
        try {
            model = definition.getModelClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ImportException(String.format("\u5b9e\u4f8b\u5316model\u5f02\u5e38\uff1a%s", definition.getModelClass().getName()), e);
        }
        Row row = sheet.getRow(rowIndex);
        IntStream.range(0, definition.getColumns().size()).forEach(cellIndex -> {
            boolean notValidEmpty;
            ColumnDefinition column = definition.getColumns().get(cellIndex);
            Object cellValue = ExcelImportUtils.getCellValue(row.getCell(cellIndex));
            boolean bl = notValidEmpty = column.isRequired() && (cellValue == null || StringUtils.isEmpty(String.valueOf(cellValue)));
            if (notValidEmpty) {
                throw new ImportException(String.format("\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff1a\u7b2c%s\u884c\u7b2c%s\u5217", rowIndex + 1, cellIndex + 1));
            }
            try {
                if (column.getValueFunction() != null) {
                    cellValue = column.getValueFunction().apply(cellValue);
                }
                BeanUtils.setProperty((Object)model, (String)column.getName(), (Object)cellValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ImportException(String.format("\u8bbe\u7f6e\u5c5e\u6027\u503c\u5f02\u5e38\uff1a\u7b2c%s\u884c\u7b2c%s\u5217", rowIndex + 1, cellIndex + 1), e);
            }
            catch (ConversionException e) {
                throw new ImportException(String.format("\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff1a\u7b2c%s\u884c\u7b2c%s\u5217\uff0c\u5c5e\u6027\u503c\uff1a%s", rowIndex + 1, cellIndex + 1, cellValue));
            }
        });
        return model;
    }

    private static Object getCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue().trim();
            }
            case NUMERIC: 
            case FORMULA: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    return HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue());
                }
                return new DecimalFormat("#.######").format(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case BLANK: {
                return "";
            }
        }
        return null;
    }

    private static void closeInputStream(XSSFWorkbook workbook, InputStream in) {
        try {
            workbook.close();
            in.close();
        }
        catch (IOException e) {
            throw new ImportException("\u5173\u95ed\u8f93\u5165\u6d41\u5f02\u5e38", e);
        }
    }

    public static List<List<?>> batchImports(InputStream inputStream, List<ImportDefinition<?>> definitions) {
        XSSFWorkbook workbook;
        if (CollectionUtils.isEmpty(definitions)) {
            throw new ImportException("\u5bfc\u5165\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u672a\u7a7a");
        }
        try {
            workbook = new XSSFWorkbook(inputStream);
        }
        catch (IOException e) {
            throw new ImportException("\u5b9e\u4f8b\u5316Workbook\u5f02\u5e38", e);
        }
        List<List<?>> dataList = IntStream.range(0, definitions.size()).mapToObj(index -> ExcelImportUtils.readData(workbook, (ImportDefinition)definitions.get(index), index)).collect(Collectors.toList());
        ExcelImportUtils.closeInputStream(workbook, inputStream);
        return dataList;
    }
}

