/*
 * Decompiled with CFR 0.152.
 */
package com.ijz.framework.export.excel.imports.definition;

import com.ijz.framework.export.exception.ExportException;
import com.ijz.framework.export.utils.StringUtils;
import java.util.function.Function;

public class ColumnDefinition {
    private String name;
    private boolean required;
    private Function valueFunction;

    private ColumnDefinition(Builder builder) {
        this.name = builder.name;
        this.required = builder.required;
        this.valueFunction = builder.valueFunction;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Function getValueFunction() {
        return this.valueFunction;
    }

    public static class Builder {
        private String name;
        private boolean required;
        private Function valueFunction;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public Builder valueFunction(Function valueFunction) {
            this.valueFunction = valueFunction;
            return this;
        }

        public ColumnDefinition build() {
            if (StringUtils.isEmpty(this.name)) {
                throw new ExportException("\u5c5e\u6027\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return new ColumnDefinition(this);
        }
    }
}

